/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.dtlocal;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsIntervalBase;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZonedDateTimeOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.common.internal.epl.datetime.interval.IntervalOp;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.time.ZonedDateTime;
import java.util.List;

public class DTLocalZonedDateTimeOpsIntervalEval
extends DTLocalEvaluatorCalOpsIntervalBase {
    public DTLocalZonedDateTimeOpsIntervalEval(List<CalendarOp> calendarOps, IntervalOp intervalOp) {
        super(calendarOps, intervalOp);
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ZonedDateTime zdt = (ZonedDateTime)target;
        zdt = DTLocalUtil.evaluateCalOpsZDT(this.calendarOps, zdt, eventsPerStream, isNewData, exprEvaluatorContext);
        long time = DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(zdt);
        return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegen(DTLocalZonedDateTimeOpsIntervalForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), DTLocalZonedDateTimeOpsIntervalEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.ZONEDDATETIME.getEPType(), "target");
        CodegenBlock block = methodNode.getBlock();
        DTLocalUtil.evaluateCalOpsZDTCodegen(block, "target", forge.calendarForges, methodNode, exprSymbol, codegenClassScope);
        block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "time", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", CodegenExpressionBuilder.ref("target")));
        block.methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ZonedDateTime start = (ZonedDateTime)startTimestamp;
        ZonedDateTime end = (ZonedDateTime)endTimestamp;
        long deltaMSec = DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(end) - DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(start);
        start = DTLocalUtil.evaluateCalOpsZDT(this.calendarOps, start, eventsPerStream, isNewData, exprEvaluatorContext);
        long startLong = DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(start);
        long endTime = startLong + deltaMSec;
        return this.intervalOp.evaluate(startLong, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegen(DTLocalZonedDateTimeOpsIntervalForge forge, CodegenExpressionRef start, CodegenExpressionRef end, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), DTLocalZonedDateTimeOpsIntervalEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.ZONEDDATETIME.getEPType(), "start").addParam(EPTypePremade.ZONEDDATETIME.getEPType(), "end");
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "startMs", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", CodegenExpressionBuilder.ref("start"))).declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "endMs", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", CodegenExpressionBuilder.ref("end"))).declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "deltaMSec", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("endMs"), "-", CodegenExpressionBuilder.ref("startMs"))).declareVar(EPTypePremade.ZONEDDATETIME.getEPType(), "result", (CodegenExpression)start);
        DTLocalUtil.evaluateCalOpsZDTCodegen(block, "result", forge.calendarForges, methodNode, exprSymbol, codegenClassScope);
        block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "startLong", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", CodegenExpressionBuilder.ref("result")));
        block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "endTime", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("startLong"), "+", CodegenExpressionBuilder.ref("deltaMSec")));
        block.methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("startLong"), CodegenExpressionBuilder.ref("endTime"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, start, end);
    }
}

