/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.eval;

import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercer;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerCal;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerDate;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerLong;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class DatetimeLongCoercerFactory {
    private static final DatetimeLongCoercerLong DATETIME_LONG_COERCER_LONG = new DatetimeLongCoercerLong();
    private static final DatetimeLongCoercerDate DATETIME_LONG_COERCER_DATE = new DatetimeLongCoercerDate();
    private static final DatetimeLongCoercerCal DATETIME_LONG_COERCER_CAL = new DatetimeLongCoercerCal();
    private static final DatetimeLongCoercerZonedDateTime DATETIME_LONG_COERCER_ZONED_DATE_TIME = new DatetimeLongCoercerZonedDateTime();

    public static DatetimeLongCoercer getCoercer(Class clazz) {
        if (JavaClassHelper.isSubclassOrImplementsInterface(clazz, Date.class)) {
            return DATETIME_LONG_COERCER_DATE;
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface(clazz, Calendar.class)) {
            return DATETIME_LONG_COERCER_CAL;
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface(clazz, LocalDateTime.class)) {
            return new DatetimeLongCoercerLocalDateTime();
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface(clazz, ZonedDateTime.class)) {
            return DATETIME_LONG_COERCER_ZONED_DATE_TIME;
        }
        return DATETIME_LONG_COERCER_LONG;
    }
}

