/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.datetimemethod.DateTimeMethodOps;
import com.espertech.esper.common.client.hook.datetimemethod.DateTimeMethodOpsModify;
import com.espertech.esper.common.client.hook.datetimemethod.DateTimeMethodOpsReformat;
import com.espertech.esper.common.client.hook.datetimemethod.DateTimeMethodValidateContext;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.TimePeriod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarForge;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarForgeFactory;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodProviderForgeFactory;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodResolver;
import com.espertech.esper.common.internal.epl.datetime.eval.ExprDotDTForge;
import com.espertech.esper.common.internal.epl.datetime.eval.ExprDotDTMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.interval.IntervalForge;
import com.espertech.esper.common.internal.epl.datetime.interval.IntervalForgeFactory;
import com.espertech.esper.common.internal.epl.datetime.plugin.DTMPluginForgeFactory;
import com.espertech.esper.common.internal.epl.datetime.plugin.DTMPluginReformatForge;
import com.espertech.esper.common.internal.epl.datetime.plugin.DTMPluginValueChangeForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForgeFactory;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFP;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPProvided;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodInputTypeMatcher;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodTypeEnum;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodUtil;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeClass;
import com.espertech.esper.common.internal.rettype.EPChainableTypeEventSingle;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.rettype.EPChainableTypeNull;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class ExprDotDTFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExprDotDTMethodDesc validateMake(StreamTypeService streamTypeService, Deque<Chainable> chainSpecStack, DatetimeMethodDesc dtMethod, String dtMethodName, EPChainableType inputType, List<ExprNode> parameters, ExprDotNodeFilterAnalyzerInput inputDesc, TimeAbacus timeAbacus, TableCompileTimeResolver tableCompileTimeResolver, ClasspathImportServiceCompileTime classpathImportService, StatementRawInfo statementRawInfo) throws ExprValidationException {
        FilterExprAnalyzerAffector filterAnalyzerDesc;
        IntervalForge intervalForge;
        ReformatForge reformatForge;
        ArrayList<CalendarForge> calendarForges;
        block15: {
            String message = "Date-time enumeration method '" + dtMethodName + "' requires either a Calendar, Date, long, LocalDateTime or ZonedDateTime value as input or events of an event type that declares a timestamp property";
            if (inputType instanceof EPChainableTypeEventSingle) {
                if (((EPChainableTypeEventSingle)inputType).getType().getStartTimestampPropertyName() == null) {
                    throw new ExprValidationException(message);
                }
            } else {
                EPChainableTypeClass classEPType;
                if (!(inputType instanceof EPChainableTypeClass) && !(inputType instanceof EPChainableTypeNull)) {
                    throw new ExprValidationException(message + " but received " + EPChainableTypeHelper.toTypeDescriptive(inputType));
                }
                if (inputType instanceof EPChainableTypeClass && !JavaClassHelper.isDatetimeClass((classEPType = (EPChainableTypeClass)inputType).getType().getType())) {
                    throw new ExprValidationException(message + " but received " + ClassHelperPrint.getClassNameFullyQualPretty(classEPType.getType()));
                }
            }
            calendarForges = new ArrayList<CalendarForge>();
            reformatForge = null;
            intervalForge = null;
            DatetimeMethodDesc currentMethod = dtMethod;
            List<ExprNode> currentParameters = parameters;
            String currentMethodName = dtMethodName;
            filterAnalyzerDesc = null;
            do {
                ExprForge[] forges = ExprDotDTFactory.getForges(currentParameters);
                DatetimeMethodProviderForgeFactory opFactory = currentMethod.getForgeFactory();
                DotMethodFPProvided footprintProvided = DotMethodUtil.getProvidedFootprint(currentParameters);
                DotMethodFP footprintFound = DotMethodUtil.validateParametersDetermineFootprint(currentMethod.getFootprints(), DotMethodTypeEnum.DATETIME, currentMethodName, footprintProvided, DotMethodInputTypeMatcher.DEFAULT_ALL);
                if (opFactory instanceof CalendarForgeFactory) {
                    CalendarForge calendarForge = ((CalendarForgeFactory)currentMethod.getForgeFactory()).getOp(currentMethod, currentMethodName, currentParameters, forges);
                    calendarForges.add(calendarForge);
                } else if (opFactory instanceof ReformatForgeFactory) {
                    reformatForge = ((ReformatForgeFactory)opFactory).getForge(inputType, timeAbacus, currentMethod, currentMethodName, currentParameters);
                    filterAnalyzerDesc = calendarForges.isEmpty() ? reformatForge.getFilterDesc(streamTypeService.getEventTypes(), currentMethod, currentParameters, inputDesc) : null;
                } else if (opFactory instanceof IntervalForgeFactory) {
                    intervalForge = ((IntervalForgeFactory)opFactory).getForge(streamTypeService, currentMethod, currentMethodName, currentParameters, timeAbacus, tableCompileTimeResolver);
                    filterAnalyzerDesc = calendarForges.isEmpty() ? intervalForge.getFilterDesc(streamTypeService.getEventTypes(), currentMethod, currentParameters, inputDesc) : null;
                } else {
                    if (!(opFactory instanceof DTMPluginForgeFactory)) throw new IllegalStateException("Invalid op factory class " + opFactory);
                    DTMPluginForgeFactory plugIn = (DTMPluginForgeFactory)opFactory;
                    DateTimeMethodValidateContext usageDesc = new DateTimeMethodValidateContext(footprintFound, streamTypeService, currentMethod, currentParameters, statementRawInfo);
                    DateTimeMethodOps ops = plugIn.validate(usageDesc);
                    if (ops == null) {
                        throw new ExprValidationException("Plug-in datetime method provider " + plugIn.getClass() + " returned a null-value for the operations");
                    }
                    EPTypeClass input = EPChainableTypeClass.fromInputOrNull(inputType);
                    if (ops instanceof DateTimeMethodOpsModify) {
                        calendarForges.add(new DTMPluginValueChangeForge(input, (DateTimeMethodOpsModify)ops, usageDesc.getCurrentParameters()));
                    } else {
                        if (!(ops instanceof DateTimeMethodOpsReformat)) throw new ExprValidationException("Plug-in datetime method ops " + ops.getClass() + " is not recognized");
                        reformatForge = new DTMPluginReformatForge(input, (DateTimeMethodOpsReformat)ops, usageDesc.getCurrentParameters());
                    }
                }
                if (chainSpecStack.isEmpty() || !DatetimeMethodResolver.isDateTimeMethod(chainSpecStack.getFirst().getRootNameOrEmptyString(), classpathImportService)) break block15;
                Chainable next = chainSpecStack.removeFirst();
                currentMethodName = next.getRootNameOrEmptyString();
                currentMethod = DatetimeMethodResolver.fromName(currentMethodName, classpathImportService);
                currentParameters = next.getParametersOrEmpty();
            } while (reformatForge == null && intervalForge == null);
            throw new ExprValidationException("Invalid input for date-time method '" + currentMethodName + "'");
        }
        EPTypeClass inputTypeClass = EPChainableTypeClass.fromInputOrNull(inputType);
        EventType inputEventType = EPChainableTypeEventSingle.fromInputOrNull(inputType);
        ExprDotDTForge dotForge = new ExprDotDTForge(calendarForges, timeAbacus, reformatForge, intervalForge, inputTypeClass, inputEventType);
        EPChainableType returnType = dotForge.getTypeInfo();
        return new ExprDotDTMethodDesc(dotForge, returnType, filterAnalyzerDesc);
    }

    private static ExprForge[] getForges(List<ExprNode> parameters) {
        ExprForge[] inputExpr = new ExprForge[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            ExprNode innerExpr = parameters.get(i);
            ExprForge inner = innerExpr.getForge();
            if (innerExpr instanceof ExprTimePeriod) {
                final ExprTimePeriod timePeriod = (ExprTimePeriod)innerExpr;
                inputExpr[i] = new ExprForge(){

                    @Override
                    public ExprEvaluator getExprEvaluator() {
                        return new ExprEvaluator(){

                            @Override
                            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                                return timePeriod.evaluateGetTimePeriod(eventsPerStream, isNewData, context);
                            }
                        };
                    }

                    @Override
                    public ExprForgeConstantType getForgeConstantType() {
                        return ExprForgeConstantType.NONCONST;
                    }

                    @Override
                    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
                        return timePeriod.evaluateGetTimePeriodCodegen(codegenMethodScope, exprSymbol, codegenClassScope);
                    }

                    @Override
                    public EPTypeClass getEvaluationType() {
                        return TimePeriod.EPTYPE;
                    }

                    @Override
                    public ExprNode getForgeRenderable() {
                        return timePeriod;
                    }
                };
                continue;
            }
            inputExpr[i] = inner;
        }
        return inputExpr;
    }
}

