/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.eval;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.lookup.AdvancedIndexConfigContextPartition;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import java.util.List;

public class FilterExprAnalyzerDTIntervalAffector
implements FilterExprAnalyzerAffector {
    private final DatetimeMethodDesc currentMethod;
    private final EventType[] typesPerStream;
    private final int targetStreamNum;
    private final String targetStartProp;
    private final String targetEndProp;
    private final Integer parameterStreamNum;
    private final String parameterStartProp;
    private final String parameterEndProp;

    public FilterExprAnalyzerDTIntervalAffector(DatetimeMethodDesc currentMethod, EventType[] typesPerStream, int targetStreamNum, String targetStartProp, String targetEndProp, Integer parameterStreamNum, String parameterStartProp, String parameterEndProp) {
        this.currentMethod = currentMethod;
        this.typesPerStream = typesPerStream;
        this.targetStreamNum = targetStreamNum;
        this.targetStartProp = targetStartProp;
        this.targetEndProp = targetEndProp;
        this.parameterStreamNum = parameterStreamNum;
        this.parameterStartProp = parameterStartProp;
        this.parameterEndProp = parameterEndProp;
    }

    public ExprNode[] getIndexExpressions() {
        return null;
    }

    public List<Pair<ExprNode, int[]>> getKeyExpressions() {
        return null;
    }

    public AdvancedIndexConfigContextPartition getOptionalIndexSpec() {
        return null;
    }

    public String getOptionalIndexName() {
        return null;
    }

    @Override
    public void apply(QueryGraphForge filterQueryGraph) {
        if (this.targetStreamNum == this.parameterStreamNum) {
            return;
        }
        ExprIdentNode targetStartExpr = ExprNodeUtilityMake.makeExprIdentNode(this.typesPerStream, this.targetStreamNum, this.targetStartProp);
        ExprIdentNode targetEndExpr = ExprNodeUtilityMake.makeExprIdentNode(this.typesPerStream, this.targetStreamNum, this.targetEndProp);
        ExprIdentNode parameterStartExpr = ExprNodeUtilityMake.makeExprIdentNode(this.typesPerStream, this.parameterStreamNum, this.parameterStartProp);
        ExprIdentNode parameterEndExpr = ExprNodeUtilityMake.makeExprIdentNode(this.typesPerStream, this.parameterStreamNum, this.parameterEndProp);
        if (targetStartExpr.getForge().getEvaluationType() != parameterStartExpr.getForge().getEvaluationType()) {
            return;
        }
        if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.BEFORE) {
            filterQueryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterStartExpr, RelationalOpEnum.LT);
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.AFTER) {
            filterQueryGraph.addRelationalOpStrict(this.targetStreamNum, targetStartExpr, this.parameterStreamNum, parameterEndExpr, RelationalOpEnum.GT);
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.COINCIDES) {
            boolean noDuration;
            filterQueryGraph.addStrictEquals(this.targetStreamNum, this.targetStartProp, targetStartExpr, this.parameterStreamNum, this.parameterStartProp, parameterStartExpr);
            boolean bl = noDuration = this.parameterEndProp.equals(this.parameterStartProp) && this.targetEndProp.equals(this.targetStartProp);
            if (!noDuration) {
                ExprIdentNode leftEndExpr = ExprNodeUtilityMake.makeExprIdentNode(this.typesPerStream, this.targetStreamNum, this.targetEndProp);
                ExprIdentNode rightEndExpr = ExprNodeUtilityMake.makeExprIdentNode(this.typesPerStream, this.parameterStreamNum, this.parameterEndProp);
                filterQueryGraph.addStrictEquals(this.targetStreamNum, this.targetEndProp, leftEndExpr, this.parameterStreamNum, this.parameterEndProp, rightEndExpr);
            }
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.DURING || this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.INCLUDES) {
            RelationalOpEnum relop = this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.DURING ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            filterQueryGraph.addRelationalOpStrict(this.parameterStreamNum, parameterStartExpr, this.targetStreamNum, targetStartExpr, relop);
            filterQueryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterEndExpr, relop);
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.FINISHES || this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.FINISHEDBY) {
            RelationalOpEnum relop = this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.FINISHES ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            filterQueryGraph.addRelationalOpStrict(this.parameterStreamNum, parameterStartExpr, this.targetStreamNum, targetStartExpr, relop);
            filterQueryGraph.addStrictEquals(this.targetStreamNum, this.targetEndProp, targetEndExpr, this.parameterStreamNum, this.parameterEndProp, parameterEndExpr);
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.MEETS) {
            filterQueryGraph.addStrictEquals(this.targetStreamNum, this.targetEndProp, targetEndExpr, this.parameterStreamNum, this.parameterStartProp, parameterStartExpr);
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.METBY) {
            filterQueryGraph.addStrictEquals(this.targetStreamNum, this.targetStartProp, targetStartExpr, this.parameterStreamNum, this.parameterEndProp, parameterEndExpr);
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.OVERLAPS || this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.OVERLAPPEDBY) {
            RelationalOpEnum relop = this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.OVERLAPS ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            filterQueryGraph.addRelationalOpStrict(this.targetStreamNum, targetStartExpr, this.parameterStreamNum, parameterStartExpr, relop);
            filterQueryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterEndExpr, relop);
            if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.OVERLAPS) {
                filterQueryGraph.addRelationalOpStrict(this.parameterStreamNum, parameterStartExpr, this.targetStreamNum, targetEndExpr, RelationalOpEnum.LT);
            } else {
                filterQueryGraph.addRelationalOpStrict(this.targetStreamNum, targetStartExpr, this.parameterStreamNum, parameterEndExpr, RelationalOpEnum.LT);
            }
        } else if (this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.STARTS || this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.STARTEDBY) {
            filterQueryGraph.addStrictEquals(this.targetStreamNum, this.targetStartProp, targetStartExpr, this.parameterStreamNum, this.parameterStartProp, parameterStartExpr);
            RelationalOpEnum relop = this.currentMethod.getDatetimeMethod() == DatetimeMethodEnum.STARTS ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            filterQueryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterEndExpr, relop);
        }
    }
}

