/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.reformatop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.settings.RuntimeSettingsTimeZoneField;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class ReformatToCalendarForge
implements ReformatForge,
ReformatOp {
    private final TimeAbacus timeAbacus;

    public ReformatToCalendarForge(TimeAbacus timeAbacus) {
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ReformatOp getOp() {
        return this;
    }

    @Override
    public Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance();
        this.timeAbacus.calendarSet(ts, cal);
        return cal;
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.CALENDAR.getEPType(), ReformatToCalendarForge.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "ts");
        methodNode.getBlock().declareVar(EPTypePremade.CALENDAR.getEPType(), "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).expression(this.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("ts"), CodegenExpressionBuilder.ref("cal"), methodNode, codegenClassScope)).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(d.getTime());
        return cal;
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.CALENDAR.getEPType(), ReformatToCalendarForge.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.DATE.getEPType(), "d").getBlock().declareVar(EPTypePremade.CALENDAR.getEPType(), "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("d"), "getTime", new CodegenExpression[0])).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(inner).call();
    }

    @Override
    public Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return cal;
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return inner;
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeInMillis(DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(ldt, TimeZone.getDefault()));
        return cal;
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.CALENDAR.getEPType(), ReformatToCalendarForge.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.LOCALDATETIME.getEPType(), "ldt").getBlock().declareVar(EPTypePremade.CALENDAR.getEPType(), "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", CodegenExpressionBuilder.ref("ldt"), timeZoneField)).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(inner).call();
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeInMillis(DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(zdt));
        return cal;
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.CALENDAR.getEPType(), ReformatToCalendarForge.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.ZONEDDATETIME.getEPType(), "zdt").getBlock().declareVar(EPTypePremade.CALENDAR.getEPType(), "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", CodegenExpressionBuilder.ref("zdt"))).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(inner).call();
    }

    @Override
    public EPTypeClass getReturnType() {
        return EPTypePremade.CALENDAR.getEPType();
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodDesc currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }
}

