/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.cache;

import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheEntryLongArrayAndObj;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheForEnumerationMethod;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheStackEntry;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class ExpressionResultCacheForEnumerationMethodImpl
implements ExpressionResultCacheForEnumerationMethod {
    private final IdentityHashMap<Object, SoftReference<ExpressionResultCacheEntryLongArrayAndObj>> enumMethodCache = new IdentityHashMap();
    private Deque<ExpressionResultCacheStackEntry> callStack;
    private Deque<Long> lastValueCacheStack;

    @Override
    public ExpressionResultCacheEntryLongArrayAndObj getEnumerationMethodLastValue(Object node) {
        SoftReference<ExpressionResultCacheEntryLongArrayAndObj> cacheRef = this.enumMethodCache.get(node);
        if (cacheRef == null) {
            return null;
        }
        ExpressionResultCacheEntryLongArrayAndObj entry = cacheRef.get();
        if (entry == null) {
            return null;
        }
        Long[] required = entry.getReference();
        if (required.length != this.lastValueCacheStack.size()) {
            return null;
        }
        Iterator<Long> prov = this.lastValueCacheStack.iterator();
        for (int i = 0; i < this.lastValueCacheStack.size(); ++i) {
            if (required[i].equals(prov.next())) continue;
            return null;
        }
        return entry;
    }

    @Override
    public void saveEnumerationMethodLastValue(Object node, Object result) {
        Long[] snapshot = this.lastValueCacheStack.toArray(new Long[this.lastValueCacheStack.size()]);
        ExpressionResultCacheEntryLongArrayAndObj entry = new ExpressionResultCacheEntryLongArrayAndObj(snapshot, result);
        this.enumMethodCache.put(node, new SoftReference<ExpressionResultCacheEntryLongArrayAndObj>(entry));
    }

    @Override
    public void pushContext(long contextNumber) {
        if (this.callStack == null) {
            this.callStack = new ArrayDeque<ExpressionResultCacheStackEntry>();
            this.lastValueCacheStack = new ArrayDeque<Long>(10);
        }
        this.lastValueCacheStack.push(contextNumber);
    }

    @Override
    public void popContext() {
        this.lastValueCacheStack.remove();
    }
}

