/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.cache;

import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheForDeclaredExprLastColl;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheForDeclaredExprLastValue;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheForEnumerationMethod;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheForPropUnwrap;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheServiceHolder;

public class ExpressionResultCacheService {
    private final int declareExprCacheSize;
    private final ThreadLocal<ExpressionResultCacheServiceHolder> threadCache;

    public ExpressionResultCacheService(final int declareExprCacheSize) {
        this.declareExprCacheSize = declareExprCacheSize;
        this.threadCache = new ThreadLocal<ExpressionResultCacheServiceHolder>(){

            @Override
            protected synchronized ExpressionResultCacheServiceHolder initialValue() {
                return new ExpressionResultCacheServiceHolder(declareExprCacheSize);
            }
        };
    }

    public ExpressionResultCacheForPropUnwrap getAllocateUnwrapProp() {
        return this.threadCache.get().getAllocateUnwrapProp();
    }

    public ExpressionResultCacheForDeclaredExprLastValue getAllocateDeclaredExprLastValue() {
        return this.threadCache.get().getAllocateDeclaredExprLastValue();
    }

    public ExpressionResultCacheForDeclaredExprLastColl getAllocateDeclaredExprLastColl() {
        return this.threadCache.get().getAllocateDeclaredExprLastColl();
    }

    public ExpressionResultCacheForEnumerationMethod getAllocateEnumerationMethod() {
        return this.threadCache.get().getAllocateEnumerationMethod();
    }

    public boolean isDeclaredExprCacheEnabled() {
        return this.declareExprCacheSize > 0;
    }
}

