/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval.plain.take;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenNames;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenParams;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumEval;
import com.espertech.esper.common.internal.epl.enummethod.eval.plain.take.EnumTakeForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class EnumTakeForgeEval
implements EnumEval {
    private final ExprEvaluator sizeEval;

    public EnumTakeForgeEval(ExprEvaluator sizeEval) {
        this.sizeEval = sizeEval;
    }

    @Override
    public Object evaluateEnumMethod(EventBean[] eventsLambda, Collection enumcoll, boolean isNewData, ExprEvaluatorContext context) {
        Object size = this.sizeEval.evaluate(eventsLambda, isNewData, context);
        if (size == null) {
            return null;
        }
        return EnumTakeForgeEval.evaluateEnumTakeMethod(enumcoll, ((Number)size).intValue());
    }

    public static CodegenExpression codegen(EnumTakeForge forge, EnumForgeCodegenParams args, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        ExprForgeCodegenSymbol scope = new ExprForgeCodegenSymbol(false, null);
        CodegenMethod methodNode = codegenMethodScope.makeChildWithScope(EPTypePremade.COLLECTION.getEPType(), EnumTakeForgeEval.class, scope, codegenClassScope).addParam(EnumForgeCodegenNames.PARAMSCOLLOBJ);
        EPTypeClass sizeType = (EPTypeClass)forge.sizeEval.getEvaluationType();
        CodegenBlock block = methodNode.getBlock().declareVar(sizeType, "size", forge.sizeEval.evaluateCodegen(sizeType, methodNode, scope, codegenClassScope));
        if (!sizeType.getType().isPrimitive()) {
            block.ifRefNullReturnNull("size");
        }
        block.methodReturn(CodegenExpressionBuilder.staticMethod(EnumTakeForgeEval.class, "evaluateEnumTakeMethod", EnumForgeCodegenNames.REF_ENUMCOLL, SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(CodegenExpressionBuilder.ref("size"), sizeType)));
        return CodegenExpressionBuilder.localMethod(methodNode, args.getEps(), args.getEnumcoll(), args.getIsNewData(), args.getExprCtx());
    }

    public static Collection evaluateEnumTakeMethod(Collection enumcoll, int size) {
        if (enumcoll.isEmpty()) {
            return enumcoll;
        }
        if (size <= 0) {
            return Collections.emptyList();
        }
        if (enumcoll.size() < size) {
            return enumcoll;
        }
        if (size == 1) {
            return Collections.singletonList(enumcoll.iterator().next());
        }
        ArrayList result = new ArrayList(size);
        for (Object next : enumcoll) {
            if (result.size() >= size) break;
            result.add(next);
        }
        return result;
    }
}

