/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval.plugin;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodForgeFactory;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodLambdaParameterDescriptor;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodLambdaParameterType;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodLambdaParameterTypeIndex;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodLambdaParameterTypeSize;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodLambdaParameterTypeStateGetter;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodLambdaParameterTypeValue;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodMode;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodModeStaticMethod;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodState;
import com.espertech.esper.common.client.hook.enummethod.EnumMethodValidateContext;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParam;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeEnumMethodBase;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumForgeDesc;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumForgeDescFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumForgeLambdaDesc;
import com.espertech.esper.common.internal.epl.enummethod.eval.plugin.EnumForgePlugin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFP;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPParam;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeClass;
import com.espertech.esper.common.internal.rettype.EPChainableTypeEventMulti;
import com.espertech.esper.common.internal.rettype.EPChainableTypeEventSingle;
import com.espertech.esper.common.internal.rettype.EPChainableTypeNull;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.MethodResolver;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchMethodException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ExprDotForgeEnumMethodPlugin
extends ExprDotForgeEnumMethodBase {
    private final EnumMethodForgeFactory forgeFactory;
    private EnumMethodModeStaticMethod mode;

    public ExprDotForgeEnumMethodPlugin(EnumMethodForgeFactory forgeFactory) {
        this.forgeFactory = forgeFactory;
    }

    @Override
    public void initialize(DotMethodFP footprint, EnumMethodEnum enumMethod, String enumMethodUsedName, EventType inputEventType, EPTypeClass collectionComponentType, List<ExprNode> parameters, StreamTypeService streamTypeService, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        EnumMethodValidateContext ctx = new EnumMethodValidateContext(footprint, inputEventType, collectionComponentType, streamTypeService, enumMethod, parameters, statementRawInfo);
        EnumMethodMode enumMethodMode = this.forgeFactory.validate(ctx);
        if (!(enumMethodMode instanceof EnumMethodModeStaticMethod)) {
            throw new ExprValidationException("Unexpected EnumMethodMode implementation, expected a provided implementation");
        }
        this.mode = (EnumMethodModeStaticMethod)enumMethodMode;
    }

    @Override
    public EnumForgeDescFactory getForgeFactory(DotMethodFP footprint, List<ExprNode> parameters, EnumMethodEnum enumMethod, String enumMethodUsedName, EventType inputEventType, EPTypeClass collectionComponentType, ExprValidationContext validationContext) {
        if (this.mode == null) {
            throw new IllegalStateException("Initialize did not take place");
        }
        return new EnumForgeDescFactoryPlugin(this.mode, enumMethodUsedName, footprint, parameters, inputEventType, collectionComponentType, validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
    }

    public EnumMethodModeStaticMethod getMode() {
        return this.mode;
    }

    private static class EnumForgeDescFactoryPlugin
    implements EnumForgeDescFactory {
        private final EnumMethodModeStaticMethod mode;
        private final String enumMethodUsedName;
        private final DotMethodFP footprint;
        private final List<ExprNode> parameters;
        private final EventType inputEventType;
        private final EPTypeClass collectionComponentType;
        private final StatementRawInfo raw;
        private final StatementCompileTimeServices services;

        public EnumForgeDescFactoryPlugin(EnumMethodModeStaticMethod mode, String enumMethodUsedName, DotMethodFP footprint, List<ExprNode> parameters, EventType inputEventType, EPTypeClass collectionComponentType, StatementRawInfo raw, StatementCompileTimeServices services) {
            this.mode = mode;
            this.enumMethodUsedName = enumMethodUsedName;
            this.footprint = footprint;
            this.parameters = parameters;
            this.inputEventType = inputEventType;
            this.collectionComponentType = collectionComponentType;
            this.raw = raw;
            this.services = services;
        }

        @Override
        public EnumForgeLambdaDesc getLambdaStreamTypesForParameter(int parameterNum) {
            DotMethodFPParam desc = this.footprint.getParameters()[parameterNum];
            if (desc.getLambdaParamNum() == 0) {
                return new EnumForgeLambdaDesc(new EventType[0], new String[0]);
            }
            ExprNode param = this.parameters.get(parameterNum);
            if (!(param instanceof ExprLambdaGoesNode)) {
                throw new IllegalStateException("Parameter " + parameterNum + " is not a lambda parameter");
            }
            ExprLambdaGoesNode goes = (ExprLambdaGoesNode)param;
            List<String> goesToNames = goes.getGoesToNames();
            EventType[] types = new EventType[desc.getLambdaParamNum()];
            String[] names = new String[desc.getLambdaParamNum()];
            for (int i = 0; i < types.length; ++i) {
                EnumMethodLambdaParameterType lambdaParamType = this.mode.getLambdaParameters().apply(new EnumMethodLambdaParameterDescriptor(parameterNum, i));
                if (lambdaParamType instanceof EnumMethodLambdaParameterTypeValue) {
                    types[i] = this.inputEventType == null ? ExprDotNodeUtility.makeTransientOAType(this.enumMethodUsedName, goesToNames.get(i), this.collectionComponentType, this.raw, this.services) : this.inputEventType;
                } else if (lambdaParamType instanceof EnumMethodLambdaParameterTypeIndex || lambdaParamType instanceof EnumMethodLambdaParameterTypeSize) {
                    types[i] = ExprDotNodeUtility.makeTransientOAType(this.enumMethodUsedName, goesToNames.get(i), EPTypePremade.INTEGERPRIMITIVE.getEPType(), this.raw, this.services);
                } else if (lambdaParamType instanceof EnumMethodLambdaParameterTypeStateGetter) {
                    EnumMethodLambdaParameterTypeStateGetter getter = (EnumMethodLambdaParameterTypeStateGetter)lambdaParamType;
                    types[i] = ExprDotNodeUtility.makeTransientOAType(this.enumMethodUsedName, goesToNames.get(i), getter.getType(), this.raw, this.services);
                } else {
                    throw new UnsupportedOperationException("Unrecognized lambda parameter type " + lambdaParamType);
                }
                names[i] = types[i] == this.inputEventType ? goesToNames.get(i) : types[i].getName();
            }
            return new EnumForgeLambdaDesc(types, names);
        }

        @Override
        public EnumForgeDesc makeEnumForgeDesc(List<ExprDotEvalParam> bodiesAndParameters, int streamCountIncoming, StatementCompileTimeServices services) throws ExprValidationException {
            EPTypeClass expectedStateReturnType;
            Method serviceMethod;
            ArrayList<EPType> parametersNext = new ArrayList<EPType>();
            parametersNext.add(this.mode.getStateClass());
            if (this.inputEventType != null) {
                parametersNext.add(EventBean.EPTYPE);
            } else {
                parametersNext.add(this.collectionComponentType);
            }
            for (ExprDotEvalParam param : bodiesAndParameters) {
                if (!(param instanceof ExprDotEvalParamLambda)) continue;
                parametersNext.add(JavaClassHelper.getBoxedType(param.getBody().getForge().getEvaluationType()));
            }
            boolean[] noFlags = new boolean[parametersNext.size()];
            try {
                serviceMethod = MethodResolver.resolveMethod(this.mode.getServiceClass(), this.mode.getMethodName(), parametersNext.toArray(new EPTypeClass[0]), false, noFlags, noFlags);
            }
            catch (MethodResolverNoSuchMethodException ex) {
                throw new ExprValidationException("Failed to find service method for enumeration-method '" + this.mode.getMethodName() + "': " + ex.getMessage(), ex);
            }
            if (!JavaClassHelper.isTypeVoid(serviceMethod.getReturnType())) {
                throw new ExprValidationException("Failed to validate service method for enumeration-method '" + this.mode.getMethodName() + "', expected void return type");
            }
            EPChainableType returnType = this.mode.getReturnType();
            if (returnType instanceof EPChainableTypeClass) {
                expectedStateReturnType = ((EPChainableTypeClass)returnType).getType();
            } else if (returnType instanceof EPChainableTypeEventSingle) {
                expectedStateReturnType = EventBean.EPTYPE;
            } else if (returnType instanceof EPChainableTypeEventMulti) {
                expectedStateReturnType = EPTypePremade.COLLECTION.getEPType();
            } else if (returnType instanceof EPChainableTypeNull) {
                expectedStateReturnType = null;
            } else {
                throw new ExprValidationException("Unrecognized return type " + returnType);
            }
            if (!JavaClassHelper.isSubclassOrImplementsInterface(this.mode.getStateClass().getType(), EnumMethodState.class)) {
                throw new ExprValidationException("State class " + this.mode.getStateClass().getTypeName() + " does implement the " + EnumMethodState.class.getName() + " interface");
            }
            EnumForgePlugin forge = new EnumForgePlugin(bodiesAndParameters, this.mode, expectedStateReturnType, streamCountIncoming, this.inputEventType);
            return new EnumForgeDesc(returnType, forge);
        }
    }
}

