/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ExprDotForgeLambdaThreeForm;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormEventPlainFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormEventPlusFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormInitFunction;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormNoParamFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormScalarFactory;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumEvent;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumEventPlus;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumScalar;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.EnumSumScalarNoParams;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.ExprDotEvalSumMethod;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.sumof.ExprDotEvalSumMethodFactory;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExprDotForgeSumOf
extends ExprDotForgeLambdaThreeForm {
    private ExprDotEvalSumMethodFactory aggMethodFactory;

    @Override
    protected EPChainableType initAndNoParamsReturnType(EventType inputEventType, EPTypeClass collectionComponentType) {
        this.aggMethodFactory = ExprDotForgeSumOf.getAggregatorFactory(collectionComponentType);
        return EPChainableTypeHelper.singleValue(JavaClassHelper.getBoxedType(this.aggMethodFactory.getValueType()));
    }

    @Override
    protected ThreeFormNoParamFactory.ForgeFunction noParamsForge(EnumMethodEnum enumMethod, EPChainableType type, StatementCompileTimeServices services) {
        return streamCountIncoming -> new EnumSumScalarNoParams(streamCountIncoming, this.aggMethodFactory);
    }

    @Override
    protected ThreeFormInitFunction initAndSingleParamReturnType(EventType inputEventType, EPTypeClass collectionComponentType) {
        return lambda -> {
            EPTypeClass type = this.validateNonNull(lambda.getBodyForge().getEvaluationType());
            this.aggMethodFactory = ExprDotForgeSumOf.getAggregatorFactory(type);
            EPTypeClass returnType = JavaClassHelper.getBoxedType(this.aggMethodFactory.getValueType());
            return EPChainableTypeHelper.singleValue(returnType);
        };
    }

    @Override
    protected ThreeFormEventPlainFactory.ForgeFunction singleParamEventPlain(EnumMethodEnum enumMethod) {
        return (lambda, typeInfo, services) -> new EnumSumEvent(lambda, this.aggMethodFactory);
    }

    @Override
    protected ThreeFormEventPlusFactory.ForgeFunction singleParamEventPlus(EnumMethodEnum enumMethod) {
        return (lambda, fieldType, numParameters, typeInfo, services) -> new EnumSumEventPlus(lambda, fieldType, numParameters, this.aggMethodFactory);
    }

    @Override
    protected ThreeFormScalarFactory.ForgeFunction singleParamScalar(EnumMethodEnum enumMethod) {
        return (lambda, eventType, numParams, typeInfo, services) -> new EnumSumScalar(lambda, eventType, numParams, this.aggMethodFactory);
    }

    private static ExprDotEvalSumMethodFactory getAggregatorFactory(EPTypeClass evalType) {
        if (JavaClassHelper.isFloatingPointClass(evalType)) {
            return ExprDotEvalSumMethodFactoryDouble.INSTANCE;
        }
        if (evalType.getType() == BigDecimal.class) {
            return ExprDotEvalSumMethodFactoryBigDecimal.INSTANCE;
        }
        if (evalType.getType() == BigInteger.class) {
            return ExprDotEvalSumMethodFactoryBigInteger.INSTANCE;
        }
        if (JavaClassHelper.getBoxedType(evalType.getType()) == Long.class) {
            return ExprDotEvalSumMethodFactoryLong.INSTANCE;
        }
        return ExprDotEvalSumMethodFactoryInteger.INSTANCE;
    }

    private static void codegenReturnSumOrNull(CodegenBlock block) {
        block.ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("cnt"), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.ref("sum"));
    }

    private static class ExprDotEvalSumMethodFactoryDouble
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryDouble INSTANCE = new ExprDotEvalSumMethodFactoryDouble();

        private ExprDotEvalSumMethodFactoryDouble() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodDouble();
        }

        @Override
        public EPTypeClass getValueType() {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(EPTypePremade.DOUBLEBOXED.getEPType(), (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodFactoryBigDecimal
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryBigDecimal INSTANCE = new ExprDotEvalSumMethodFactoryBigDecimal();

        private ExprDotEvalSumMethodFactoryBigDecimal() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodBigDecimal();
        }

        @Override
        public EPTypeClass getValueType() {
            return EPTypePremade.BIGDECIMAL.getEPType();
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(EPTypePremade.BIGDECIMAL.getEPType(), "sum", CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.constant(0.0)));
            block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", value));
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", CodegenExpressionBuilder.cast(EPTypePremade.BIGDECIMAL.getEPType(), (CodegenExpression)value)));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodFactoryBigInteger
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryBigInteger INSTANCE = new ExprDotEvalSumMethodFactoryBigInteger();

        private ExprDotEvalSumMethodFactoryBigInteger() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodBigInteger();
        }

        @Override
        public EPTypeClass getValueType() {
            return EPTypePremade.BIGINTEGER.getEPType();
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(EPTypePremade.BIGINTEGER.getEPType(), "sum", CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.constant(0)));
            block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", value));
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", CodegenExpressionBuilder.cast(EPTypePremade.BIGINTEGER.getEPType(), (CodegenExpression)value)));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodFactoryLong
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryLong INSTANCE = new ExprDotEvalSumMethodFactoryLong();

        private ExprDotEvalSumMethodFactoryLong() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodLong();
        }

        @Override
        public EPTypeClass getValueType() {
            return EPTypePremade.LONGBOXED.getEPType();
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(EPTypePremade.LONGBOXED.getEPType(), (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodFactoryInteger
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryInteger INSTANCE = new ExprDotEvalSumMethodFactoryInteger();

        private ExprDotEvalSumMethodFactoryInteger() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodInteger();
        }

        @Override
        public EPTypeClass getValueType() {
            return EPTypePremade.INTEGERBOXED.getEPType();
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.incrementRef("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(EPTypePremade.INTEGERBOXED.getEPType(), (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodInteger
    implements ExprDotEvalSumMethod {
        protected int sum;
        protected long cnt;

        private ExprDotEvalSumMethodInteger() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Integer)object).intValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodLong
    implements ExprDotEvalSumMethod {
        protected long sum;
        protected long cnt;

        private ExprDotEvalSumMethodLong() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Long)object).longValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodBigInteger
    implements ExprDotEvalSumMethod {
        protected BigInteger sum = BigInteger.valueOf(0L);
        protected long cnt;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum = this.sum.add((BigInteger)object);
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodBigDecimal
    implements ExprDotEvalSumMethod {
        protected BigDecimal sum = new BigDecimal(0.0);
        protected long cnt;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum = this.sum.add((BigDecimal)object);
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodDouble
    implements ExprDotEvalSumMethod {
        protected double sum;
        protected long cnt;

        private ExprDotEvalSumMethodDouble() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Double)object).doubleValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }
}

