/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.accessagg;

import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;

public class ExprAggMultiFunctionUtil {
    public static int validateStreamWildcardGetStreamNum(ExprNode node) throws ExprValidationException {
        if (!(node instanceof ExprStreamUnderlyingNode)) {
            throw new IllegalStateException("Expression not stream-wildcard");
        }
        ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)node;
        if (und.getStreamId() == -1) {
            throw new ExprValidationException("The expression does not resolve to a stream");
        }
        return und.getStreamId();
    }

    public static void validateWildcardStreamNumbers(StreamTypeService streamTypeService, String aggFuncName) throws ExprValidationException {
        ExprAggMultiFunctionUtil.checkWildcardNotJoinOrSubquery(streamTypeService, aggFuncName);
        ExprAggMultiFunctionUtil.checkWildcardHasStream(streamTypeService, aggFuncName);
    }

    public static void checkWildcardNotJoinOrSubquery(StreamTypeService streamTypeService, String aggFuncName) throws ExprValidationException {
        if (streamTypeService.getStreamNames().length > 1) {
            throw new ExprValidationException(ExprAggMultiFunctionUtil.getErrorPrefix(aggFuncName) + " requires that in joins or subqueries the stream-wildcard (stream-alias.*) syntax is used instead");
        }
    }

    private static void checkWildcardHasStream(StreamTypeService streamTypeService, String aggFuncName) throws ExprValidationException {
        if (streamTypeService.getStreamNames().length == 0) {
            throw new ExprValidationException(ExprAggMultiFunctionUtil.getErrorPrefix(aggFuncName) + " requires that at least one stream is provided");
        }
    }

    public static String getErrorPrefix(String aggFuncName) {
        return "The '" + aggFuncName + "' aggregation function";
    }
}

