/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.method;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.count.AggregationForgeFactoryCount;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;

public class ExprCountNode
extends ExprAggregateNodeBase {
    private boolean hasFilter;

    public ExprCountNode(boolean distinct) {
        super(distinct);
    }

    @Override
    public AggregationForgeFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.positionalParams.length > 2 || this.positionalParams.length == 0) {
            throw this.makeExceptionExpectedParamNum(1, 2);
        }
        EPType childType = null;
        boolean ignoreNulls = false;
        if (this.positionalParams.length == 1 && this.positionalParams[0] instanceof ExprWildcard) {
            this.validateNotDistinct();
        } else if (this.positionalParams.length == 1) {
            childType = this.positionalParams[0].getForge().getEvaluationType();
            ignoreNulls = true;
        } else {
            this.hasFilter = true;
            if (!(this.positionalParams[0] instanceof ExprWildcard)) {
                childType = this.positionalParams[0].getForge().getEvaluationType();
                ignoreNulls = true;
            } else {
                this.validateNotDistinct();
            }
            super.validateFilter(this.positionalParams[1]);
            this.optionalFilter = this.positionalParams[1];
        }
        EPTypeClass serdeType = childType == EPTypeNull.INSTANCE ? null : (EPTypeClass)childType;
        DataInputOutputSerdeForge distinctValueSerde = this.isDistinct ? validationContext.getSerdeResolver().serdeForAggregationDistinct(serdeType, validationContext.getStatementRawInfo()) : null;
        return new AggregationForgeFactoryCount(this, ignoreNulls, childType, distinctValueSerde);
    }

    @Override
    public String getAggregationFunctionName() {
        return "count";
    }

    public boolean isHasFilter() {
        return this.hasFilter;
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return node instanceof ExprCountNode;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return true;
    }

    private void validateNotDistinct() throws ExprValidationException {
        if (super.isDistinct()) {
            throw new ExprValidationException("Invalid use of the 'distinct' keyword with count and wildcard");
        }
    }
}

