/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.method;

import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.rate.AggregationForgeFactoryRate;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityAggregation;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimestampNode;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class ExprRateAggNode
extends ExprAggregateNodeBase {
    public ExprRateAggNode(boolean distinct) {
        super(distinct);
    }

    @Override
    public AggregationForgeFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.positionalParams.length == 0) {
            throw new ExprValidationException("The rate aggregation function minimally requires a numeric constant or expression as a parameter.");
        }
        ExprNode first = this.positionalParams[0];
        if (first.getForge().getForgeConstantType().isCompileTimeConstant()) {
            long intervalTime;
            String message = "The rate aggregation function requires a numeric constant or time period as the first parameter in the constant-value notation";
            if (first instanceof ExprTimePeriod) {
                double secInterval = ((ExprTimePeriod)first).evaluateAsSeconds(null, true, null);
                intervalTime = validationContext.getClasspathImportService().getTimeAbacus().deltaForSecondsDouble(secInterval);
            } else if (ExprNodeUtilityQuery.isConstant(first)) {
                if (!JavaClassHelper.isNumeric(first.getForge().getEvaluationType())) {
                    throw new ExprValidationException(message);
                }
                Number num = (Number)first.getForge().getExprEvaluator().evaluate(null, true, null);
                intervalTime = validationContext.getClasspathImportService().getTimeAbacus().deltaForSecondsNumber(num);
            } else {
                throw new ExprValidationException(message);
            }
            this.positionalParams = this.optionalFilter == null ? ExprNodeUtilityQuery.EMPTY_EXPR_ARRAY : new ExprNode[]{this.optionalFilter};
            return new AggregationForgeFactoryRate(this, true, intervalTime, validationContext.getClasspathImportService().getTimeAbacus());
        }
        String message = "The rate aggregation function requires a property or expression returning a non-constant long-type value as the first parameter in the timestamp-property notation";
        if (!JavaClassHelper.isTypeLong(first.getForge().getEvaluationType())) {
            throw new ExprValidationException(message);
        }
        if (first.getForge().getForgeConstantType().isConstant()) {
            throw new ExprValidationException(message);
        }
        if (first instanceof ExprTimestampNode) {
            throw new ExprValidationException("The rate aggregation function does not allow the current runtime timestamp as a parameter");
        }
        if (this.positionalParams.length > 1 && !JavaClassHelper.isNumeric(this.positionalParams[1].getForge().getEvaluationType())) {
            throw new ExprValidationException("The rate aggregation function accepts an expression returning a numeric value to accumulate as an optional second parameter");
        }
        boolean hasDataWindows = ExprNodeUtilityAggregation.hasRemoveStreamForAggregations(first, validationContext.getStreamTypeService(), validationContext.isResettingAggregations());
        if (!hasDataWindows) {
            throw new ExprValidationException("The rate aggregation function in the timestamp-property notation requires data windows");
        }
        if (this.optionalFilter != null) {
            this.positionalParams = ExprNodeUtilityMake.addExpression(this.positionalParams, this.optionalFilter);
        }
        return new AggregationForgeFactoryRate(this, false, -1L, validationContext.getClasspathImportService().getTimeAbacus());
    }

    @Override
    public String getAggregationFunctionName() {
        return "rate";
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return node instanceof ExprRateAggNode;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }
}

