/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.chain;

import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import java.util.Collection;
import java.util.List;

public class ChainableCall
extends Chainable {
    private String name;
    private String nameUnescaped;
    private List<ExprNode> parameters;

    public ChainableCall(boolean distinct, boolean optional, String name, String nameUnescaped, List<ExprNode> parameters) {
        super(distinct, optional);
        this.name = name;
        this.nameUnescaped = nameUnescaped;
        this.parameters = parameters;
    }

    public ChainableCall(String name, List<ExprNode> parameters) {
        this.name = name;
        this.nameUnescaped = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<ExprNode> parameters) {
        this.parameters = parameters;
    }

    public String getNameUnescaped() {
        return this.nameUnescaped;
    }

    public List<ExprNode> getParameters() {
        return this.parameters;
    }

    @Override
    public void addParametersTo(Collection<ExprNode> result) {
        result.addAll(this.parameters);
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        ExprNodeUtilityQuery.acceptParams(visitor, this.parameters);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        ExprNodeUtilityQuery.acceptParams(visitor, this.parameters);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        ExprNodeUtilityQuery.acceptParams(visitor, this.parameters, parent);
    }

    @Override
    public String getRootNameOrEmptyString() {
        return this.name;
    }

    @Override
    public List<ExprNode> getParametersOrEmpty() {
        return this.parameters;
    }

    @Override
    public void validateExpressions(ExprNodeOrigin origin, ExprValidationContext validationContext) throws ExprValidationException {
        ChainableCall.validateExpressions(this.parameters, origin, validationContext);
    }

    public String toString() {
        return "ChainableCall{name='" + this.name + "', parameters=" + this.parameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainableCall that = (ChainableCall)o;
        return super.equalsChainable(that) && this.name.equals(that.name) && ExprNodeUtilityCompare.deepEquals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

