/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.codegen;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;

public class CodegenLegoCast {
    public static CodegenExpression castSafeFromObjectType(EPTypeClass targetType, CodegenExpression value) {
        if (targetType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (targetType.getType() == Object.class) {
            return value;
        }
        if (JavaClassHelper.isTypeVoid(targetType)) {
            throw new IllegalArgumentException("Invalid void target type for cast");
        }
        if (targetType.getType().isPrimitive()) {
            return CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(targetType), value);
        }
        return CodegenExpressionBuilder.cast(targetType, value);
    }

    public static CodegenExpression castSafeFromObjectType(EPType targetType, CodegenExpression value) {
        if (targetType == null || targetType == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPTypeClass typeClass = (EPTypeClass)targetType;
        if (typeClass.getType() == Object.class) {
            return value;
        }
        if (JavaClassHelper.isTypeVoid(typeClass)) {
            throw new IllegalArgumentException("Invalid void target type for cast");
        }
        if (typeClass.getType().isPrimitive()) {
            return CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(typeClass), value);
        }
        return CodegenExpressionBuilder.cast(typeClass, value);
    }

    public static void asDoubleNullReturnNull(CodegenBlock block, String variable, ExprForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        EPType type = forge.getEvaluationType();
        if (type == EPTypeNull.INSTANCE) {
            block.declareVar(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), variable, CodegenExpressionBuilder.constant(0));
        } else {
            EPTypeClass typeClass = (EPTypeClass)type;
            if (typeClass.getType() == Double.TYPE) {
                block.declareVar(typeClass, variable, forge.evaluateCodegen(typeClass, codegenMethodScope, exprSymbol, codegenClassScope));
            } else {
                String holder = variable + "_";
                block.declareVar(typeClass, holder, forge.evaluateCodegen(typeClass, codegenMethodScope, exprSymbol, codegenClassScope));
                if (!typeClass.getType().isPrimitive()) {
                    block.ifRefNullReturnNull(holder);
                }
                block.declareVar(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), variable, SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(CodegenExpressionBuilder.ref(holder), typeClass));
            }
        }
    }
}

