/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.codegen;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class CodegenLegoMethodExpression {
    private static final String PASS_NAME = "pass";

    public static CodegenExpression codegenBooleanExpressionReturnTrueFalse(ExprForge forge, CodegenClassScope classScope, CodegenMethod parent, CodegenExpression eps, CodegenExpression isNewData, CodegenExpression exprEvalCtx) {
        CodegenLegoMethodExpression.checkEvaluationType(forge);
        CodegenMethod expressionMethod = CodegenLegoMethodExpression.codegenBooleanExpressionBoxedToPrimitive(forge, parent, classScope);
        return CodegenExpressionBuilder.localMethod(expressionMethod, eps, isNewData, exprEvalCtx);
    }

    public static CodegenMethod codegenExpression(ExprForge forge, CodegenMethod parent, CodegenClassScope classScope) {
        EPType evaluationType = forge.getEvaluationType();
        EPTypeClass methodReturnType = EPTypePremade.OBJECT.getEPType();
        if (evaluationType instanceof EPTypeClass) {
            methodReturnType = (EPTypeClass)evaluationType;
        }
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod exprMethod = parent.makeChildWithScope(methodReturnType, CodegenLegoMethodExpression.class, (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        if (evaluationType == null || evaluationType == EPTypeNull.INSTANCE) {
            exprMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
        } else {
            CodegenExpression expression = forge.evaluateCodegen(methodReturnType, exprMethod, exprSymbol, classScope);
            exprSymbol.derivedSymbolsCodegen(parent, exprMethod.getBlock(), classScope);
            if (!JavaClassHelper.isTypeVoid(methodReturnType)) {
                exprMethod.getBlock().methodReturn(expression);
            } else {
                exprMethod.getBlock().expression(expression);
            }
        }
        return exprMethod;
    }

    private static CodegenMethod codegenBooleanExpressionBoxedToPrimitive(ExprForge forge, CodegenMethod parent, CodegenClassScope classScope) {
        EPType evaluationType = forge.getEvaluationType();
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod exprMethod = parent.makeChildWithScope(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), CodegenLegoMethodExpression.class, (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression expression = forge.evaluateCodegen((EPTypeClass)evaluationType, exprMethod, exprSymbol, classScope);
        exprSymbol.derivedSymbolsCodegen(parent, exprMethod.getBlock(), classScope);
        if (((EPTypeClass)evaluationType).getType().isPrimitive()) {
            exprMethod.getBlock().methodReturn(expression);
        } else {
            exprMethod.getBlock().declareVar((EPTypeClass)evaluationType, PASS_NAME, expression).ifRefNull(PASS_NAME).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.ref(PASS_NAME));
        }
        return exprMethod;
    }

    private static void checkEvaluationType(ExprForge forge) {
        EPType evaluationType = forge.getEvaluationType();
        if (!JavaClassHelper.isTypeBoolean(evaluationType)) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
    }
}

