/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.codegen;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.codegen.StaticMethodCodegenArgDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStaticMethodEval;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.ValueAndFieldDesc;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class StaticMethodCallHelper {
    public static StaticMethodCodegenArgDesc[] allArgumentExpressions(ExprForge[] forges, Method method, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        StaticMethodCodegenArgDesc[] args = new StaticMethodCodegenArgDesc[forges.length];
        for (int i = 0; i < forges.length; ++i) {
            ExprForge child = forges[i];
            EPType childType = child.getEvaluationType();
            String name = "r" + i;
            if (childType == null || childType == EPTypeNull.INSTANCE) {
                Parameter parameter = method.getParameters()[i];
                EPTypeClass parameterType = ClassHelperGenericType.getParameterType(parameter);
                args[i] = new StaticMethodCodegenArgDesc(name, parameterType, CodegenExpressionBuilder.constantNull());
                continue;
            }
            EPTypeClass childTypeClass = (EPTypeClass)childType;
            args[i] = new StaticMethodCodegenArgDesc(name, childTypeClass, child.evaluateCodegen(childTypeClass, codegenMethodScope, exprSymbol, codegenClassScope));
        }
        return args;
    }

    public static void appendArgExpressions(StaticMethodCodegenArgDesc[] args, CodegenBlock block) {
        for (int i = 0; i < args.length; ++i) {
            block.declareVar(args[i].getDeclareType(), args[i].getBlockRefName(), args[i].getArgExpression());
        }
    }

    public static void appendCatch(CodegenBlock tryBlock, Method reflectionMethod, String statementName, String classOrPropertyName, boolean rethrow, StaticMethodCodegenArgDesc[] args) {
        CodegenBlock catchBlock = tryBlock.tryEnd().addCatch(EPTypePremade.THROWABLE.getEPType(), "t").declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "argArray", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.constant(args.length)));
        for (int i = 0; i < args.length; ++i) {
            catchBlock.assignArrayElement("argArray", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.ref(args[i].getBlockRefName()));
        }
        Class<?>[] paramTypes = reflectionMethod.getParameterTypes();
        catchBlock.staticMethod(ExprDotNodeForgeStaticMethodEval.class, "staticMethodEvalHandleInvocationException", CodegenExpressionBuilder.constant(statementName), CodegenExpressionBuilder.constant(reflectionMethod.getName()), CodegenExpressionBuilder.constant(paramTypes), CodegenExpressionBuilder.constant(classOrPropertyName), CodegenExpressionBuilder.ref("argArray"), CodegenExpressionBuilder.ref("t"), CodegenExpressionBuilder.constant(rethrow));
    }

    public static CodegenExpression codegenInvokeExpression(ValueAndFieldDesc optionalTargetObject, Method reflectionMethod, StaticMethodCodegenArgDesc[] args, CodegenClassScope codegenClassScope) {
        CodegenExpression[] expressions = new CodegenExpression[args.length];
        for (int i = 0; i < expressions.length; ++i) {
            expressions[i] = CodegenExpressionBuilder.ref(args[i].getBlockRefName());
        }
        if (optionalTargetObject == null) {
            return CodegenExpressionBuilder.staticMethod(reflectionMethod.getDeclaringClass(), reflectionMethod.getName(), expressions);
        }
        if (optionalTargetObject.getValue() != null && optionalTargetObject.getValue().getClass().isEnum()) {
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.enumValue(optionalTargetObject.getValue().getClass(), optionalTargetObject.getValue().toString()), reflectionMethod.getName(), expressions);
        }
        return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.publicConstValue(optionalTargetObject.getField().getDeclaringClass(), optionalTargetObject.getField().getName()), reflectionMethod.getName(), expressions);
    }
}

