/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.EnumValue;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprConstantNodeImpl
extends ExprNodeBase
implements ExprConstantNode,
ExprEvaluator,
ExprForgeInstrumentable {
    private Object value;
    private final EPType type;
    private EnumValue enumValue;
    private final String stringConstantWhenProvided;

    public ExprConstantNodeImpl(Object value, String stringConstantWhenProvided) {
        this.value = value;
        this.stringConstantWhenProvided = stringConstantWhenProvided;
        this.type = value == null ? EPTypeNull.INSTANCE : JavaClassHelper.getPrimitiveType(value.getClass());
    }

    public ExprConstantNodeImpl(Object value) {
        this(value, (String)null);
    }

    public ExprConstantNodeImpl(EnumValue enumValue) {
        this.stringConstantWhenProvided = null;
        this.enumValue = enumValue;
        this.type = ClassHelperGenericType.getFieldEPType(enumValue.getEnumField());
        try {
            this.value = enumValue.getEnumField().get(null);
        }
        catch (IllegalAccessException e) {
            throw new EPException("Exception accessing field '" + enumValue.getEnumField().getName() + "': " + e.getMessage(), e);
        }
    }

    public ExprConstantNodeImpl(Object value, EPType valueType) {
        this.stringConstantWhenProvided = null;
        this.value = value;
        this.type = valueType;
    }

    public ExprConstantNodeImpl(Object value, Class valueType) {
        this.stringConstantWhenProvided = null;
        this.value = value;
        this.type = value == null ? (valueType == null ? EPTypeNull.INSTANCE : ClassHelperGenericType.getClassEPType(valueType)) : JavaClassHelper.getPrimitiveType(ClassHelperGenericType.getClassEPType(value.getClass()));
    }

    public ExprConstantNodeImpl(Class type) {
        this.type = type == null ? EPTypeNull.INSTANCE : ClassHelperGenericType.getClassEPType(JavaClassHelper.getBoxedType(type));
        this.value = null;
        this.stringConstantWhenProvided = null;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.COMPILETIMECONST;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public EPType getEvaluationType() {
        return this.type;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public String getStringConstantWhenProvided() {
        return this.stringConstantWhenProvided;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public boolean constantAvailable() {
        return true;
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprConst", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).noqparam().build();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.value == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (this.enumValue != null) {
            return CodegenExpressionBuilder.publicConstValue(this.enumValue.getEnumClass(), this.enumValue.getEnumField().getName());
        }
        if (this.value.getClass().isEnum()) {
            return CodegenExpressionBuilder.enumValue(this.value.getClass(), this.value.toString());
        }
        return CodegenExpressionBuilder.constant(this.value);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        return null;
    }

    public boolean isConstantResult() {
        return true;
    }

    @Override
    public Object getConstantValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public EPType getConstantType() {
        return this.type;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.value;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        if (this.value instanceof String) {
            writer.append("\"" + this.value + "\"");
        } else if (this.value == null) {
            writer.append("null");
        } else {
            writer.append(this.value.toString());
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprConstantNodeImpl)) {
            return false;
        }
        ExprConstantNodeImpl other = (ExprConstantNodeImpl)node;
        if (other.value == null && this.value != null) {
            return false;
        }
        if (other.value != null && this.value == null) {
            return false;
        }
        if (other.value == null && this.value == null) {
            return true;
        }
        return other.value.equals(this.value);
    }
}

