/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import java.util.List;

public class ExprNodeUtilityCompare {
    public static boolean deepEqualsIsSubset(ExprNode[] subset, ExprNode[] superset) {
        for (ExprNode subsetNode : subset) {
            boolean found = false;
            for (ExprNode supersetNode : superset) {
                if (!ExprNodeUtilityCompare.deepEquals(subsetNode, supersetNode, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEqualsIgnoreDupAndOrder(ExprNode[] setOne, ExprNode[] setTwo) {
        if (setOne.length == 0 && setTwo.length != 0 || setOne.length != 0 && setTwo.length == 0) {
            return false;
        }
        boolean[] foundTwo = new boolean[setTwo.length];
        for (ExprNode one : setOne) {
            boolean found = false;
            for (int i = 0; i < setTwo.length; ++i) {
                if (!ExprNodeUtilityCompare.deepEquals(one, setTwo[i], false)) continue;
                found = true;
                foundTwo[i] = true;
            }
            if (found) continue;
            return false;
        }
        for (int i = 0; i < foundTwo.length; ++i) {
            if (foundTwo[i]) continue;
            for (ExprNode one : setOne) {
                if (ExprNodeUtilityCompare.deepEquals(one, setTwo[i], false)) break;
            }
            return false;
        }
        return true;
    }

    public static boolean deepEquals(ExprNode nodeOne, ExprNode nodeTwo, boolean ignoreStreamPrefix) {
        if (nodeOne.getChildNodes().length != nodeTwo.getChildNodes().length) {
            return false;
        }
        if (!nodeOne.equalsNode(nodeTwo, ignoreStreamPrefix)) {
            return false;
        }
        for (int i = 0; i < nodeOne.getChildNodes().length; ++i) {
            ExprNode childNodeTwo;
            ExprNode childNodeOne = nodeOne.getChildNodes()[i];
            if (ExprNodeUtilityCompare.deepEquals(childNodeOne, childNodeTwo = nodeTwo.getChildNodes()[i], ignoreStreamPrefix)) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEqualsNullChecked(ExprNode nodeOne, ExprNode nodeTwo, boolean ignoreStreamPrefix) {
        if (nodeOne == null) {
            return nodeTwo == null;
        }
        return nodeTwo != null && ExprNodeUtilityCompare.deepEquals(nodeOne, nodeTwo, ignoreStreamPrefix);
    }

    public static boolean deepEquals(ExprNode[] one, ExprNode[] two, boolean ignoreStreamPrefix) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (ExprNodeUtilityCompare.deepEquals(one[i], two[i], ignoreStreamPrefix)) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(List<ExprNode> one, List<ExprNode> two) {
        if (one.size() != two.size()) {
            return false;
        }
        for (int i = 0; i < one.size(); ++i) {
            if (ExprNodeUtilityCompare.deepEquals(one.get(i), two.get(i), false)) continue;
            return false;
        }
        return true;
    }
}

