/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeUtilityEvaluate {
    private static final Logger log = LoggerFactory.getLogger(ExprNodeUtilityEvaluate.class);

    public static int evaluateIntOptional(ExprEvaluator evalOptional, EventBean event, int defaultValue, ExprEvaluatorContext exprEvaluatorContext) {
        if (evalOptional == null) {
            return defaultValue;
        }
        Integer precedenceResult = (Integer)evalOptional.evaluate(new EventBean[]{event}, true, exprEvaluatorContext);
        if (precedenceResult != null) {
            return precedenceResult;
        }
        return defaultValue;
    }

    public static Object evaluateValidationTimeNoStreams(ExprEvaluator evaluator, ExprEvaluatorContext context, String expressionName) throws ExprValidationException {
        try {
            return evaluator.evaluate(null, true, context);
        }
        catch (EPException ex) {
            throw new ExprValidationException("Invalid " + expressionName + " expression: " + ex.getMessage(), ex);
        }
        catch (RuntimeException ex) {
            log.warn("Invalid " + expressionName + " expression evaluation: {}", (Object)ex.getMessage(), (Object)ex);
            throw new ExprValidationException("Invalid " + expressionName + " expression");
        }
    }

    public static void applyFilterExpressionIterable(Iterator<EventBean> iterator, ExprEvaluator filterExpression, ExprEvaluatorContext exprEvaluatorContext, Collection<EventBean> eventsInWindow) {
        EventBean[] events = new EventBean[1];
        while (iterator.hasNext()) {
            events[0] = iterator.next();
            Object result = filterExpression.evaluate(events, true, exprEvaluatorContext);
            if (result == null || !((Boolean)result).booleanValue()) continue;
            eventsInWindow.add(events[0]);
        }
    }

    public static EventBean[] applyFilterExpression(ExprEvaluator filter, EventBean streamZeroEvent, EventBean[] streamOneEvents, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] eventsPerStream = new EventBean[2];
        eventsPerStream[0] = streamZeroEvent;
        EventBean[] filtered = new EventBean[streamOneEvents.length];
        int countPass = 0;
        EventBean[] eventBeanArray = streamOneEvents;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean eventBean;
            eventsPerStream[1] = eventBean = eventBeanArray[i];
            Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (result == null || !result.booleanValue()) continue;
            filtered[countPass] = eventBean;
            ++countPass;
        }
        if (countPass == streamOneEvents.length) {
            return streamOneEvents;
        }
        return EventBeanUtility.resizeArray(filtered, countPass);
    }

    public static boolean applyFilterExpression(ExprEvaluator filter, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
        return result != null && result != false;
    }

    public static Object[] evaluateExpressions(ExprEvaluator[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] results = new Object[parameters.length];
        int count = 0;
        for (ExprEvaluator expr : parameters) {
            try {
                results[count] = expr.evaluate(null, true, exprEvaluatorContext);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Failed expression evaluation in crontab timer-at for parameter " + count + ": " + ex.getMessage();
                log.error(message, (Throwable)ex);
                throw new IllegalArgumentException(message);
            }
        }
        return results;
    }
}

