/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecRaw;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeVarargOnlyArrayForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalUnderlyingEvaluator;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalUnderlyingEvaluatorTable;
import com.espertech.esper.common.internal.epl.expression.ops.ExprAndNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprAndNodeImpl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprOrNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.ComparatorHashableMultiKey;
import com.espertech.esper.common.internal.util.ComparatorHashableMultiKeyCasting;
import com.espertech.esper.common.internal.util.ComparatorHashableMultiKeyCollating;
import com.espertech.esper.common.internal.util.ComparatorObjectArray;
import com.espertech.esper.common.internal.util.ComparatorObjectArrayCasting;
import com.espertech.esper.common.internal.util.ComparatorObjectArrayCollating;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.ObjectCollatingComparator;
import com.espertech.esper.common.internal.util.ObjectComparator;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class ExprNodeUtilityMake {
    public static Comparator<Object> getComparatorHashableMultiKeys(EPType[] sortCriteriaTypes, boolean isSortUsingCollator, boolean[] isDescendingValues) {
        boolean hasStringTypes = false;
        boolean[] stringTypes = new boolean[sortCriteriaTypes.length];
        int count = 0;
        for (int i = 0; i < sortCriteriaTypes.length; ++i) {
            if (JavaClassHelper.isTypeString(sortCriteriaTypes[i])) {
                hasStringTypes = true;
                stringTypes[count] = true;
            }
            ++count;
        }
        if (sortCriteriaTypes.length > 1) {
            if (!hasStringTypes || !isSortUsingCollator) {
                ComparatorHashableMultiKey comparatorMK = new ComparatorHashableMultiKey(isDescendingValues);
                return new ComparatorHashableMultiKeyCasting(comparatorMK);
            }
            ComparatorHashableMultiKeyCollating comparatorMk = new ComparatorHashableMultiKeyCollating(isDescendingValues, stringTypes);
            return new ComparatorHashableMultiKeyCasting(comparatorMk);
        }
        if (!hasStringTypes || !isSortUsingCollator) {
            return new ObjectComparator(isDescendingValues[0]);
        }
        return new ObjectCollatingComparator(isDescendingValues[0]);
    }

    public static Comparator<Object> getComparatorObjectArrayNonHashable(EPType[] sortCriteriaTypes, boolean isSortUsingCollator, boolean[] isDescendingValues) {
        boolean hasStringTypes = false;
        boolean[] stringTypes = new boolean[sortCriteriaTypes.length];
        int count = 0;
        for (int i = 0; i < sortCriteriaTypes.length; ++i) {
            if (JavaClassHelper.isTypeString(sortCriteriaTypes[i])) {
                hasStringTypes = true;
                stringTypes[count] = true;
            }
            ++count;
        }
        if (sortCriteriaTypes.length > 1) {
            if (!hasStringTypes || !isSortUsingCollator) {
                ComparatorObjectArray comparatorMK = new ComparatorObjectArray(isDescendingValues);
                return new ComparatorObjectArrayCasting(comparatorMK);
            }
            ComparatorObjectArrayCollating comparatorMk = new ComparatorObjectArrayCollating(isDescendingValues, stringTypes);
            return new ComparatorObjectArrayCasting(comparatorMk);
        }
        if (!hasStringTypes || !isSortUsingCollator) {
            return new ObjectComparator(isDescendingValues[0]);
        }
        return new ObjectCollatingComparator(isDescendingValues[0]);
    }

    public static ExprForge makeUnderlyingForge(int streamNum, EPTypeClass resultType, TableMetaData tableMetadata) {
        if (tableMetadata != null) {
            return new ExprEvalUnderlyingEvaluatorTable(streamNum, resultType, tableMetadata);
        }
        return new ExprEvalUnderlyingEvaluator(streamNum, resultType);
    }

    static ExprForge[] makeVarargArrayForges(Method method, ExprForge[] childForges) throws ExprValidationException {
        ExprForge lastForge;
        EPType lastReturns;
        int varargArrayLength;
        ExprForge[] forges = new ExprForge[method.getParameterTypes().length];
        EPTypeClass parameterType = ClassHelperGenericType.getParameterType(method.getParameters()[method.getParameterTypes().length - 1]);
        EPTypeClass varargClass = JavaClassHelper.getArrayComponentType(parameterType);
        EPTypeClass varargClassBoxed = JavaClassHelper.getBoxedType(varargClass);
        if (method.getParameterTypes().length > 1) {
            System.arraycopy(childForges, 0, forges, 0, forges.length - 1);
        }
        if ((varargArrayLength = childForges.length - method.getParameterTypes().length + 1) == 1 && (lastReturns = (lastForge = childForges[method.getParameterTypes().length - 1]).getEvaluationType()) != null && lastReturns != EPTypeNull.INSTANCE && ((EPTypeClass)lastReturns).getType().isArray()) {
            forges[method.getParameterTypes().length - 1] = lastForge;
            return forges;
        }
        ExprForge[] varargForges = new ExprForge[varargArrayLength];
        SimpleNumberCoercer[] coercers = new SimpleNumberCoercer[varargForges.length];
        boolean needCoercion = false;
        for (int i = 0; i < varargArrayLength; ++i) {
            int childIndex = i + method.getParameterTypes().length - 1;
            EPType resultType = childForges[childIndex].getEvaluationType();
            varargForges[i] = childForges[childIndex];
            if (resultType == null || resultType == EPTypeNull.INSTANCE) {
                if (!varargClass.getType().isPrimitive()) continue;
                throw new ExprValidationException("Expression returns null-typed value and varargs does not accept null values");
            }
            EPTypeClass resultTypeClass = (EPTypeClass)resultType;
            if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)resultTypeClass, varargClass) || JavaClassHelper.getBoxedType(resultTypeClass).getType() == varargClassBoxed.getType()) continue;
            needCoercion = true;
            coercers[i] = SimpleNumberCoercerFactory.getCoercer(resultTypeClass, varargClassBoxed);
        }
        ExprNodeVarargOnlyArrayForge varargForge = new ExprNodeVarargOnlyArrayForge(varargForges, varargClass, (SimpleNumberCoercer[])(needCoercion ? coercers : null));
        forges[method.getParameterTypes().length - 1] = varargForge;
        return forges;
    }

    public static ExprNode[] addExpression(ExprNode[] expressions, ExprNode expression) {
        ExprNode[] target = new ExprNode[expressions.length + 1];
        System.arraycopy(expressions, 0, target, 0, expressions.length);
        target[expressions.length] = expression;
        return target;
    }

    public static UnsupportedOperationException makeUnsupportedCompileTime() {
        return new UnsupportedOperationException("The operation is not available at compile time");
    }

    public static ExprIdentNode makeExprIdentNode(EventType[] typesPerStream, int streamId, String property) {
        return new ExprIdentNodeImpl(typesPerStream[streamId], property, streamId);
    }

    public static ExprNode connectExpressionsByLogicalAndWhenNeeded(Collection<ExprNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.iterator().next();
        }
        return ExprNodeUtilityMake.connectExpressionsByLogicalAnd(nodes);
    }

    public static ExprNode connectExpressionsByLogicalAndWhenNeeded(ExprNode left, ExprNode right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        ExprAndNodeImpl andNode = new ExprAndNodeImpl();
        andNode.addChildNode(left);
        andNode.addChildNode(right);
        return andNode;
    }

    public static ExprNode connectExpressionsByLogicalOrWhenNeeded(Collection<ExprNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.iterator().next();
        }
        return ExprNodeUtilityMake.connectExpressionsByLogicalOr(nodes);
    }

    public static ExprNode connectExpressionsByLogicalAnd(List<ExprNode> nodes, ExprNode optionalAdditionalFilter) {
        if (nodes.isEmpty()) {
            return optionalAdditionalFilter;
        }
        if (optionalAdditionalFilter == null) {
            if (nodes.size() == 1) {
                return nodes.get(0);
            }
            return ExprNodeUtilityMake.connectExpressionsByLogicalAnd(nodes);
        }
        if (nodes.size() == 1) {
            return ExprNodeUtilityMake.connectExpressionsByLogicalAnd(Arrays.asList(nodes.get(0), optionalAdditionalFilter));
        }
        ExprAndNode andNode = ExprNodeUtilityMake.connectExpressionsByLogicalAnd(nodes);
        andNode.addChildNode(optionalAdditionalFilter);
        return andNode;
    }

    public static ExprAndNode connectExpressionsByLogicalAnd(Collection<ExprNode> nodes) {
        if (nodes.size() < 2) {
            throw new IllegalArgumentException("Invalid empty or 1-element list of nodes");
        }
        ExprAndNodeImpl andNode = new ExprAndNodeImpl();
        for (ExprNode node : nodes) {
            andNode.addChildNode(node);
        }
        return andNode;
    }

    public static ExprOrNode connectExpressionsByLogicalOr(Collection<ExprNode> nodes) {
        if (nodes.size() < 2) {
            throw new IllegalArgumentException("Invalid empty or 1-element list of nodes");
        }
        ExprOrNode orNode = new ExprOrNode();
        for (ExprNode node : nodes) {
            orNode.addChildNode(node);
        }
        return orNode;
    }

    public static void setChildIdentNodesOptionalEvent(ExprNode exprNode) {
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        exprNode.accept(visitor);
        for (ExprIdentNode node : visitor.getExprProperties()) {
            node.setOptionalEvent(true);
        }
    }

    public static String getSubqueryInfoText(ExprSubselectNode subselect) {
        String text = "subquery number " + (subselect.getSubselectNumber() + 1);
        StreamSpecRaw streamRaw = subselect.getStatementSpecRaw().getStreamSpecs().get(0);
        if (streamRaw instanceof FilterStreamSpecRaw) {
            text = text + " querying " + ((FilterStreamSpecRaw)streamRaw).getRawFilterSpec().getEventTypeName();
        }
        return text;
    }
}

