/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeStreamSelectVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExprNodeUtilityQuery {
    public static final ExprNode[] EMPTY_EXPR_ARRAY = new ExprNode[0];
    public static final ExprForge[] EMPTY_FORGE_ARRAY = new ExprForge[0];

    public static ExprForge[] forgesForProperties(EventType[] eventTypes, String[] propertyNames, int[] keyStreamNums) {
        ExprForge[] forges = new ExprForge[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            ExprIdentNodeImpl node = new ExprIdentNodeImpl(eventTypes[keyStreamNums[i]], propertyNames[i], keyStreamNums[i]);
            forges[i] = node.getForge();
        }
        return forges;
    }

    public static boolean isConstant(ExprNode exprNode) {
        return exprNode.getForge().getForgeConstantType().isConstant();
    }

    public static Set<String> getPropertyNamesIfAllProps(ExprNode[] expressions) {
        for (ExprNode expression : expressions) {
            if (expression instanceof ExprIdentNode) continue;
            return null;
        }
        HashSet<String> uniquePropertyNames = new HashSet<String>();
        for (ExprNode expression : expressions) {
            ExprIdentNode identNode = (ExprIdentNode)expression;
            uniquePropertyNames.add(identNode.getUnresolvedPropertyName());
        }
        return uniquePropertyNames;
    }

    public static List<Pair<ExprNode, ExprNode>> findExpression(ExprNode selectExpression, ExprNode searchExpression) {
        ArrayList<Pair<ExprNode, ExprNode>> pairs = new ArrayList<Pair<ExprNode, ExprNode>>();
        if (ExprNodeUtilityCompare.deepEquals(selectExpression, searchExpression, false)) {
            pairs.add(new Pair<Object, ExprNode>(null, selectExpression));
            return pairs;
        }
        ExprNodeUtilityQuery.findExpressionChildRecursive(selectExpression, searchExpression, pairs);
        return pairs;
    }

    private static void findExpressionChildRecursive(ExprNode parent, ExprNode searchExpression, List<Pair<ExprNode, ExprNode>> pairs) {
        for (ExprNode child : parent.getChildNodes()) {
            if (ExprNodeUtilityCompare.deepEquals(child, searchExpression, false)) {
                pairs.add(new Pair<ExprNode, ExprNode>(parent, child));
                continue;
            }
            ExprNodeUtilityQuery.findExpressionChildRecursive(child, searchExpression, pairs);
        }
    }

    public static String[] getIdentResolvedPropertyNames(ExprNode[] nodes) {
        String[] propertyNames = new String[nodes.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!(nodes[i] instanceof ExprIdentNode)) {
                throw new IllegalArgumentException("Expressions are not ident nodes");
            }
            propertyNames[i] = ((ExprIdentNode)nodes[i]).getResolvedPropertyName();
        }
        return propertyNames;
    }

    public static EPType[] getExprResultTypes(ExprNode[] nodes) {
        EPType[] types = new EPType[nodes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = nodes[i].getForge().getEvaluationType();
        }
        return types;
    }

    public static EPType[] getExprResultTypes(ExprForge[] nodes) {
        EPType[] types = new EPType[nodes.length];
        for (int i = 0; i < types.length; ++i) {
            EPType type = nodes[i].getEvaluationType();
            types[i] = type == null ? EPTypeNull.INSTANCE : type;
        }
        return types;
    }

    public static ExprNode[] toArray(Collection<ExprNode> expressions) {
        if (expressions.isEmpty()) {
            return EMPTY_EXPR_ARRAY;
        }
        return expressions.toArray(new ExprNode[expressions.size()]);
    }

    public static ExprEvaluator[] getEvaluatorsNoCompile(ExprNode[] exprNodes) {
        if (exprNodes == null) {
            return null;
        }
        ExprEvaluator[] eval = new ExprEvaluator[exprNodes.length];
        for (int i = 0; i < exprNodes.length; ++i) {
            ExprNode node = exprNodes[i];
            if (node == null) continue;
            eval[i] = node.getForge().getExprEvaluator();
        }
        return eval;
    }

    public static ExprForge[] getForges(ExprNode[] exprNodes) {
        if (exprNodes == null) {
            return null;
        }
        ExprForge[] forge = new ExprForge[exprNodes.length];
        for (int i = 0; i < exprNodes.length; ++i) {
            ExprNode node = exprNodes[i];
            if (node == null) continue;
            forge[i] = node.getForge();
        }
        return forge;
    }

    public static ExprEvaluator[] getEvaluatorsNoCompile(ExprForge[] forges) {
        if (forges == null) {
            return null;
        }
        ExprEvaluator[] eval = new ExprEvaluator[forges.length];
        for (int i = 0; i < forges.length; ++i) {
            ExprForge forge = forges[i];
            if (forge == null) continue;
            eval[i] = forge.getExprEvaluator();
        }
        return eval;
    }

    public static ExprEvaluator[] getEvaluatorsNoCompile(List<ExprNode> childNodes) {
        ExprEvaluator[] eval = new ExprEvaluator[childNodes.size()];
        for (int i = 0; i < childNodes.size(); ++i) {
            eval[i] = childNodes.get(i).getForge().getExprEvaluator();
        }
        return eval;
    }

    public static EPType[] getExprResultTypes(List<ExprNode> expressions) {
        EPType[] returnTypes = new EPType[expressions.size()];
        for (int i = 0; i < expressions.size(); ++i) {
            returnTypes[i] = expressions.get(i).getForge().getEvaluationType();
        }
        return returnTypes;
    }

    public static void acceptParams(ExprNodeVisitor visitor, List<ExprNode> params) {
        for (ExprNode param : params) {
            param.accept(visitor);
        }
    }

    public static void acceptParams(ExprNodeVisitorWithParent visitor, List<ExprNode> params) {
        for (ExprNode param : params) {
            param.accept(visitor);
        }
    }

    public static void acceptParams(ExprNodeVisitorWithParent visitor, List<ExprNode> params, ExprNode parent) {
        for (ExprNode param : params) {
            param.acceptChildnodes(visitor, parent);
        }
    }

    public static String[] getPropertiesPerExpressionExpectSingle(ExprNode[] exprNodes) {
        String[] indexedProperties = new String[exprNodes.length];
        for (int i = 0; i < exprNodes.length; ++i) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            exprNodes[i].accept(visitor);
            if (visitor.getExprProperties().size() != 1) {
                throw new IllegalStateException("Failed to find indexed property");
            }
            indexedProperties[i] = visitor.getExprProperties().iterator().next().getSecond();
        }
        return indexedProperties;
    }

    public static boolean isExpressionsAllPropsOnly(ExprNode[] exprNodes) {
        for (int i = 0; i < exprNodes.length; ++i) {
            if (exprNodes[i] instanceof ExprIdentNode) continue;
            return false;
        }
        return true;
    }

    public static Set<Integer> getIdentStreamNumbers(ExprNode child) {
        HashSet<Integer> streams = new HashSet<Integer>();
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        child.accept(visitor);
        for (ExprIdentNode node : visitor.getExprProperties()) {
            streams.add(node.getStreamId());
        }
        return streams;
    }

    public static List<Pair<Integer, String>> getExpressionProperties(ExprNode exprNode, boolean visitAggregateNodes) {
        ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(visitAggregateNodes);
        exprNode.accept(visitor);
        return visitor.getExprProperties();
    }

    public static boolean isAllConstants(List<ExprNode> parameters) {
        for (ExprNode node : parameters) {
            if (node.getForge().getForgeConstantType().isCompileTimeConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasStreamSelect(List<ExprNode> exprNodes) {
        ExprNodeStreamSelectVisitor visitor = new ExprNodeStreamSelectVisitor(false);
        for (ExprNode node : exprNodes) {
            node.accept(visitor);
            if (!visitor.hasStreamSelect()) continue;
            return true;
        }
        return false;
    }

    public static List<ExprNode> collectChainParameters(List<Chainable> chainSpec) {
        ArrayList<ExprNode> result = new ArrayList<ExprNode>();
        for (Chainable chainElement : chainSpec) {
            chainElement.addParametersTo(result);
        }
        return result;
    }

    public static void acceptChain(ExprNodeVisitor visitor, List<Chainable> chainSpec) {
        for (Chainable chain : chainSpec) {
            chain.accept(visitor);
        }
    }

    public static void acceptChain(ExprNodeVisitorWithParent visitor, List<Chainable> chainSpec) {
        for (Chainable chain : chainSpec) {
            chain.accept(visitor);
        }
    }

    public static void acceptChain(ExprNodeVisitorWithParent visitor, List<Chainable> chainSpec, ExprNode parent) {
        for (Chainable chain : chainSpec) {
            chain.accept(visitor, parent);
        }
    }

    public static Map<ExprDeclaredNode, List<ExprDeclaredNode>> getDeclaredExpressionCallHierarchy(ExprDeclaredNode[] declaredExpressions) {
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        HashMap<ExprDeclaredNode, List<ExprDeclaredNode>> calledToCallerMap = new HashMap<ExprDeclaredNode, List<ExprDeclaredNode>>();
        for (ExprDeclaredNode node : declaredExpressions) {
            visitor.reset();
            node.acceptNoVisitParams(visitor);
            for (ExprDeclaredNode called : visitor.getDeclaredExpressions()) {
                if (called == node) continue;
                ArrayList<ExprDeclaredNode> callers = (ArrayList<ExprDeclaredNode>)calledToCallerMap.get(called);
                if (callers == null) {
                    callers = new ArrayList<ExprDeclaredNode>(2);
                    calledToCallerMap.put(called, callers);
                }
                callers.add(node);
            }
            if (calledToCallerMap.containsKey(node)) continue;
            calledToCallerMap.put(node, Collections.emptyList());
        }
        return calledToCallerMap;
    }
}

