/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.type.FrequencyParameter;
import com.espertech.esper.common.internal.type.IntParameter;
import com.espertech.esper.common.internal.type.ListParameter;
import com.espertech.esper.common.internal.type.NumberSetParameter;
import com.espertech.esper.common.internal.type.RangeParameter;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNumberSetList
extends ExprNodeBase
implements ExprForge,
ExprEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExprNumberSetList.class);
    private static final String METHOD_HANDLEEXPRNUMBERSETLISTADD = "handleExprNumberSetListAdd";
    private static final String METHOD_HANDLEEXPRNUMBERSETLISTEMPTY = "handleExprNumberSetListEmpty";
    private transient ExprEvaluator[] evaluators;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public EPTypeClass getEvaluationType() {
        return ListParameter.EPTYPE;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        String delimiter = "";
        writer.append('[');
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        do {
            ExprNode expr = it.next();
            writer.append(delimiter);
            expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
            delimiter = ",";
        } while (it.hasNext());
        writer.append(']');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        int max = -1;
        for (ExprNode child : this.getChildNodes()) {
            if (child.getForge().getForgeConstantType().ordinal() <= max) continue;
            max = child.getForge().getForgeConstantType().ordinal();
        }
        if (max == -1) {
            return ExprForgeConstantType.COMPILETIMECONST;
        }
        return ExprForgeConstantType.values()[max];
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprNumberSetList;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluators = ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.getChildNodes());
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            EPType type = this.getChildNodes()[i].getForge().getEvaluationType();
            if (FrequencyParameter.EPTYPE.equals(type) || RangeParameter.EPTYPE.equals(type) || JavaClassHelper.isNumericNonFP(type)) continue;
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayList<NumberSetParameter> parameters = new ArrayList<NumberSetParameter>();
        for (ExprEvaluator child : this.evaluators) {
            Object value = child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            ExprNumberSetList.handleExprNumberSetListAdd(value, parameters);
        }
        ExprNumberSetList.handleExprNumberSetListEmpty(parameters);
        return new ListParameter(parameters);
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(ListParameter.EPTYPE, ExprNumberSetList.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.LIST.getEPType(), "parameters", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYLIST.getEPType(), new CodegenExpression[0]));
        int count = -1;
        for (ExprNode node : this.getChildNodes()) {
            ExprForge forge = node.getForge();
            EPTypeClass evaluationType = (EPTypeClass)forge.getEvaluationType();
            String refname = "value" + ++count;
            block.declareVar(evaluationType, refname, forge.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope)).staticMethod(ExprNumberSetList.class, METHOD_HANDLEEXPRNUMBERSETLISTADD, CodegenExpressionBuilder.ref(refname), CodegenExpressionBuilder.ref("parameters"));
        }
        block.staticMethod(ExprNumberSetList.class, METHOD_HANDLEEXPRNUMBERSETLISTEMPTY, CodegenExpressionBuilder.ref("parameters")).methodReturn(CodegenExpressionBuilder.newInstance(ListParameter.EPTYPE, CodegenExpressionBuilder.ref("parameters")));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    public static void handleExprNumberSetListEmpty(List<NumberSetParameter> parameters) {
        if (parameters.isEmpty()) {
            log.warn("Empty list of values in list parameter, using upper bounds");
            parameters.add(new IntParameter(Integer.MAX_VALUE));
        }
    }

    public static void handleExprNumberSetListAdd(Object value, List<NumberSetParameter> parameters) {
        if (value == null) {
            log.info("Null value returned for lower bounds value in list parameter, skipping parameter");
            return;
        }
        if (value instanceof FrequencyParameter || value instanceof RangeParameter) {
            parameters.add((NumberSetParameter)value);
            return;
        }
        int intValue = ((Number)value).intValue();
        parameters.add(new IntParameter(intValue));
    }
}

