/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.declared.compiletime;

import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesCompileTime;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCompileTimeResolver;
import com.espertech.esper.common.internal.epl.util.CompileTimeResolver;
import java.util.Set;

public class ExprDeclaredCompileTimeResolverImpl
implements ExprDeclaredCompileTimeResolver {
    private final String moduleName;
    private final Set<String> moduleUses;
    private final ExprDeclaredCompileTimeRegistry locals;
    private final PathRegistry<String, ExpressionDeclItem> path;
    private final ModuleDependenciesCompileTime moduleDependencies;
    private final boolean isFireAndForget;

    public ExprDeclaredCompileTimeResolverImpl(String moduleName, Set<String> moduleUses, ExprDeclaredCompileTimeRegistry locals, PathRegistry<String, ExpressionDeclItem> path, ModuleDependenciesCompileTime moduleDependencies, boolean isFireAndForget) {
        this.moduleName = moduleName;
        this.moduleUses = moduleUses;
        this.locals = locals;
        this.path = path;
        this.moduleDependencies = moduleDependencies;
        this.isFireAndForget = isFireAndForget;
    }

    @Override
    public ExpressionDeclItem resolve(String name) {
        ExpressionDeclItem localExpr = this.locals.getExpressions().get(name);
        if (localExpr != null) {
            return localExpr;
        }
        try {
            Pair<ExpressionDeclItem, String> expression = this.path.getAnyModuleExpectSingle(name, this.moduleUses);
            if (expression != null) {
                if (!this.isFireAndForget && !NameAccessModifier.visible(expression.getFirst().getVisibility(), expression.getFirst().getModuleName(), this.moduleName)) {
                    return null;
                }
                this.moduleDependencies.addPathExpression(name, expression.getSecond());
                return expression.getFirst();
            }
        }
        catch (PathException e) {
            throw CompileTimeResolver.makePathAmbiguous(PathRegistryObjectType.EXPRDECL, name, e);
        }
        return null;
    }
}

