/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffectorProvider;
import com.espertech.esper.common.internal.filterspec.FilterSpecCompilerAdvIndexDesc;
import com.espertech.esper.common.internal.filterspec.FilterSpecCompilerAdvIndexDescProvider;
import com.espertech.esper.common.internal.settings.SettingsApplicationDotMethod;
import java.io.StringWriter;

public class ExprAppDotMethodImpl
extends ExprNodeBase
implements FilterSpecCompilerAdvIndexDescProvider,
FilterExprAnalyzerAffectorProvider {
    private final SettingsApplicationDotMethod desc;

    public ExprAppDotMethodImpl(SettingsApplicationDotMethod desc) {
        this.desc = desc;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.desc.validate(validationContext);
        return null;
    }

    public SettingsApplicationDotMethod getDesc() {
        return this.desc;
    }

    @Override
    public FilterSpecCompilerAdvIndexDesc getFilterSpecDesc() {
        return this.desc.getFilterSpecCompilerAdvIndexDesc();
    }

    @Override
    public FilterExprAnalyzerAffector getAffector(boolean isOuterJoin) {
        return isOuterJoin ? null : this.desc.getFilterExprAnalyzerAffector();
    }

    @Override
    public ExprForge getForge() {
        return this.desc.getForge();
    }

    public ExprEvaluator getExprEvaluator() {
        return this.desc.getForge().getExprEvaluator();
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append(this.desc.getLhsName());
        writer.append("(");
        ExprNodeUtilityPrint.toExpressionStringMinPrecedenceAsList(this.desc.getLhs(), writer);
        writer.append(").");
        writer.append(this.desc.getDotMethodName());
        writer.append("(");
        writer.append(this.desc.getRhsName());
        writer.append("(");
        ExprNodeUtilityPrint.toExpressionStringMinPrecedenceAsList(this.desc.getRhs(), writer);
        writer.append("))");
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprAppDotMethodImpl)) {
            return false;
        }
        ExprAppDotMethodImpl other = (ExprAppDotMethodImpl)node;
        if (!this.desc.getLhsName().equals(other.getDesc().getLhsName())) {
            return false;
        }
        if (!this.desc.getDotMethodName().equals(other.getDesc().getDotMethodName())) {
            return false;
        }
        if (!this.desc.getRhsName().equals(other.getDesc().getRhsName())) {
            return false;
        }
        if (!ExprNodeUtilityCompare.deepEquals(this.desc.getLhs(), other.getDesc().getLhs(), false)) {
            return false;
        }
        return ExprNodeUtilityCompare.deepEquals(this.desc.getRhs(), other.getDesc().getRhs(), false);
    }
}

