/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEvalVisitor;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuckEvalPlain;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuckEvalUnderlying;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuckEvalWrapArray;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Method;

public class ExprDotMethodForgeNoDuck
implements ExprDotForge {
    private final String optionalStatementName;
    private final Method method;
    private final EPTypeClass methodTargetType;
    private final ExprForge[] parameters;
    private final WrapType wrapType;

    public ExprDotMethodForgeNoDuck(String optionalStatementName, Method method, EPTypeClass methodTargetType, ExprForge[] parameters, WrapType wrapType) {
        this.optionalStatementName = optionalStatementName;
        this.method = method;
        this.methodTargetType = methodTargetType;
        this.parameters = parameters;
        this.wrapType = wrapType;
    }

    @Override
    public EPChainableType getTypeInfo() {
        if (this.wrapType == WrapType.WRAPARRAY) {
            EPTypeClass returnType = ClassHelperGenericType.getMethodReturnEPType(this.method);
            EPTypeClass componentType = JavaClassHelper.getArrayComponentType(returnType);
            return EPChainableTypeHelper.collectionOfSingleValue(componentType);
        }
        return EPChainableTypeHelper.fromMethod(this.method, this.methodTargetType);
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitMethod(this.method.getName());
    }

    @Override
    public ExprDotEval getDotEvaluator() {
        ExprEvaluator[] evaluators = ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.parameters);
        if (this.wrapType == WrapType.WRAPARRAY) {
            return new ExprDotMethodForgeNoDuckEvalWrapArray(this, evaluators);
        }
        if (this.wrapType == WrapType.PLAIN) {
            return new ExprDotMethodForgeNoDuckEvalPlain(this, evaluators);
        }
        return new ExprDotMethodForgeNoDuckEvalUnderlying(this, evaluators);
    }

    @Override
    public CodegenExpression codegen(CodegenExpression inner, EPTypeClass innerType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        if (this.wrapType == WrapType.WRAPARRAY) {
            return ExprDotMethodForgeNoDuckEvalWrapArray.codegenWrapArray(this, inner, innerType, parent, symbols, classScope);
        }
        if (this.wrapType == WrapType.PLAIN) {
            return ExprDotMethodForgeNoDuckEvalPlain.codegenPlain(this, inner, innerType, parent, symbols, classScope);
        }
        return ExprDotMethodForgeNoDuckEvalUnderlying.codegenUnderlying(this, inner, innerType, parent, symbols, classScope);
    }

    public String getOptionalStatementName() {
        return this.optionalStatementName;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExprForge[] getParameters() {
        return this.parameters;
    }

    public WrapType getWrapType() {
        return this.wrapType;
    }

    public static enum WrapType {
        WRAPARRAY,
        UNDERLYING,
        PLAIN;

    }
}

