/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.exception.ExceptionHandlerExceptionType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementTryCatch;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuck;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprDotMethodForgeNoDuckEvalPlain
implements ExprDotEval {
    private static final Logger log = LoggerFactory.getLogger(ExprDotMethodForgeNoDuckEvalPlain.class);
    private static final String METHOD_HANDLETARGETEXCEPTION = "handleTargetException";
    protected final ExprDotMethodForgeNoDuck forge;
    private final ExprEvaluator[] parameters;

    ExprDotMethodForgeNoDuckEvalPlain(ExprDotMethodForgeNoDuck forge, ExprEvaluator[] parameters) {
        this.forge = forge;
        this.parameters = parameters;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target == null) {
            return null;
        }
        Object[] args = new Object[this.parameters.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.parameters[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        try {
            return this.forge.getMethod().invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ExprDotMethodForgeNoDuckEvalPlain.handleTargetException(this.forge.getOptionalStatementName(), this.forge.getMethod().getName(), this.forge.getMethod().getParameterTypes(), target.getClass().getName(), args, e, exprEvaluatorContext);
            return null;
        }
    }

    public EPChainableType getTypeInfo() {
        return this.forge.getTypeInfo();
    }

    @Override
    public ExprDotForge getDotForge() {
        return this.forge;
    }

    public static CodegenExpression codegenPlain(ExprDotMethodForgeNoDuck forge, CodegenExpression inner, EPTypeClass innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        EPTypeClass returnType;
        if (forge.getWrapType() == ExprDotMethodForgeNoDuck.WrapType.WRAPARRAY) {
            returnType = ClassHelperGenericType.getMethodReturnEPType(forge.getMethod());
        } else {
            EPType result = EPChainableTypeHelper.getNormalizedEPType(forge.getTypeInfo());
            if (result == EPTypeNull.INSTANCE) {
                return CodegenExpressionBuilder.constantNull();
            }
            returnType = JavaClassHelper.getBoxedType((EPTypeClass)result);
        }
        EPTypeClass declaringType = ClassHelperGenericType.getClassEPType(forge.getMethod().getDeclaringClass());
        CodegenMethod methodNode = codegenMethodScope.makeChild(returnType, ExprDotMethodForgeNoDuckEvalPlain.class, (CodegenScope)codegenClassScope).addParam(declaringType, "target");
        CodegenBlock block = methodNode.getBlock();
        if (!innerType.getType().isPrimitive() && !JavaClassHelper.isTypeVoid(returnType)) {
            block.ifRefNullReturnNull("target");
        }
        CodegenExpression[] args = new CodegenExpression[forge.getParameters().length];
        for (int i = 0; i < forge.getParameters().length; ++i) {
            String name = "p" + i;
            EPType type = forge.getParameters()[i].getEvaluationType();
            if (type == null || type == EPTypeNull.INSTANCE) {
                block.declareVar(EPTypePremade.OBJECT.getEPType(), name, CodegenExpressionBuilder.constantNull());
            } else {
                EPTypeClass typeClass = (EPTypeClass)type;
                block.declareVar(typeClass, name, forge.getParameters()[i].evaluateCodegen(typeClass, methodNode, exprSymbol, codegenClassScope));
            }
            args[i] = CodegenExpressionBuilder.ref(name);
        }
        CodegenBlock tryBlock = block.tryCatch();
        CodegenExpression invocation = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("target"), forge.getMethod().getName(), args);
        CodegenStatementTryCatch tryCatch = JavaClassHelper.isTypeVoid(returnType) ? tryBlock.expression(invocation).tryEnd() : tryBlock.tryReturn(CodegenLegoCast.castSafeFromObjectType(returnType, invocation));
        CodegenBlock catchBlock = tryCatch.addCatch(EPTypePremade.THROWABLE.getEPType(), "t");
        catchBlock.declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "args", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.constant(forge.getParameters().length)));
        for (int i = 0; i < forge.getParameters().length; ++i) {
            catchBlock.assignArrayElement("args", CodegenExpressionBuilder.constant(i), args[i]);
        }
        catchBlock.staticMethod(ExprDotMethodForgeNoDuckEvalPlain.class, METHOD_HANDLETARGETEXCEPTION, CodegenExpressionBuilder.constant(forge.getOptionalStatementName()), CodegenExpressionBuilder.constant(forge.getMethod().getName()), CodegenExpressionBuilder.constant(forge.getMethod().getParameterTypes()), CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("target")).add("getClass", new CodegenExpression[0]).add("getName", new CodegenExpression[0]), CodegenExpressionBuilder.ref("args"), CodegenExpressionBuilder.ref("t"), exprSymbol.getAddExprEvalCtx(methodNode));
        if (JavaClassHelper.isTypeVoid(returnType)) {
            block.methodEnd();
        } else {
            block.methodReturn(CodegenExpressionBuilder.constantNull());
        }
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    public static void handleTargetException(String optionalStatementName, String methodName, Class[] methodParams, String targetClassName, Object[] args, Throwable t, ExprEvaluatorContext exprEvaluatorContext) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        String message = JavaClassHelper.getMessageInvocationTarget(optionalStatementName, methodName, methodParams, targetClassName, args, t);
        log.error(message, t);
        exprEvaluatorContext.getExceptionHandlingService().handleException(t, exprEvaluatorContext.getDeploymentId(), exprEvaluatorContext.getStatementName(), null, ExceptionHandlerExceptionType.PROCESS, null);
    }
}

