/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodResolver;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapArrayScalar;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotNonLambdaForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotNonLambdaFragmentForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotNonLambdaFragmentIndexedForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotNonLambdaIndexedForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotNonLambdaMappedForge;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionNode;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableArray;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableCall;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableName;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandlerDefault;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityResolve;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamRefNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationPropertyException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprAppDotMethodImpl;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEnumerationSourceForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEnumerationSourceForgeForProps;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForgeLocal;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForgeTableAccess;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForgeTableIdent;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForgeTableReset;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodRootNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputExpr;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgePropertyExpr;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeRootChild;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStaticMethod;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStream;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeTransposeAsStream;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeVariable;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeRealizedChain;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeSubprop;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableIdentNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SettingsApplicationDotMethodBase;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SettingsApplicationDotMethodPointInsideRectange;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SettingsApplicationDotMethodRectangeIntersectsRectangle;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.epl.streamtype.PropertyResolutionDescriptor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeUtil;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnAggregation;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterIndexedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterMappedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.propertyparser.PropertyParserNoDep;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeClass;
import com.espertech.esper.common.internal.rettype.EPChainableTypeEventMulti;
import com.espertech.esper.common.internal.rettype.EPChainableTypeEventSingle;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.settings.ClasspathImportCompileTimeUtil;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.ValueAndFieldDesc;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExprDotNodeImpl
extends ExprNodeBase
implements ExprDotNode,
ExprStreamRefNode,
ExprNodeInnerNodeProvider {
    private List<Chainable> chainSpec;
    private final boolean isDuckTyping;
    private final boolean isUDFCache;
    private transient ExprDotNodeForge forge;

    public ExprDotNodeImpl(List<Chainable> chainSpec, boolean isDuckTyping, boolean isUDFCache) {
        this.chainSpec = Collections.unmodifiableList(chainSpec);
        this.isDuckTyping = isDuckTyping;
        this.isUDFCache = isUDFCache;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Pair<ExprDotNodeAggregationMethodRootNode, List<Chainable>> aggregationMethodNode;
        Pair<ExprNode, List<Chainable>> tableNode;
        ExprAppDotMethodImpl appDotMethod = this.getAppDotMethod(validationContext.isFilterExpression());
        if (appDotMethod != null) {
            return appDotMethod;
        }
        if (validationContext.getStreamTypeService().hasTableTypes() && validationContext.getTableCompileTimeResolver() != null && this.chainSpec.size() > 1 && this.chainSpec.get(0) instanceof ChainableName && (tableNode = TableCompileTimeUtil.getTableNodeChainable(validationContext.getStreamTypeService(), this.chainSpec, validationContext.isAllowTableAggReset(), validationContext.getTableCompileTimeResolver())) != null) {
            ExprNode node = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DOTNODE, tableNode.getFirst(), validationContext);
            if (tableNode.getSecond().isEmpty()) {
                return node;
            }
            ArrayList modifiedChain = new ArrayList(tableNode.getSecond());
            this.setChainSpec(modifiedChain);
            this.addChildNode(node);
        }
        if ((aggregationMethodNode = this.handleAggregationMethod(validationContext)) != null) {
            if (aggregationMethodNode.getSecond().isEmpty()) {
                return aggregationMethodNode.getFirst();
            }
            ArrayList<Chainable> modifiedChain = new ArrayList<Chainable>((Collection)aggregationMethodNode.getSecond());
            this.setChainSpec(modifiedChain);
            this.getChildNodes()[0] = aggregationMethodNode.getFirst();
        }
        ExprNodeUtilityValidate.validate(ExprNodeOrigin.DOTNODEPARAMETER, this.chainSpec, validationContext);
        boolean hasEnumerationMethod = false;
        for (Chainable chainable2 : this.chainSpec) {
            hasEnumerationMethod |= this.isEnumerationMethod(chainable2, validationContext);
        }
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        if (this.getChildNodes().length != 0) {
            ExprDotNodeRealizedChain evals;
            ExprNode rootNode = this.getChildNodes()[0];
            EPType rootEvaluationType = rootNode.getForge().getEvaluationType();
            EPTypeClass rootEvaluationTypeClassOrNull = rootEvaluationType == null || rootEvaluationType == EPTypeNull.INSTANCE ? null : (EPTypeClass)rootEvaluationType;
            EPChainableType rootEvalTypeNonEnum = EPChainableTypeHelper.singleValue(rootEvaluationTypeClassOrNull);
            ExprDotEnumerationSourceForge enumSrc = ExprDotNodeUtility.getEnumerationSource(rootNode, validationContext.getStreamTypeService(), hasEnumerationMethod, validationContext.isDisablePropertyExpressionEventCollCache(), validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
            boolean canEnum = enumSrc.getReturnType() != null;
            ChainEval chainEval = (chainable, streamNumberOfEnum) -> ExprDotNodeUtility.getChainEvaluators(streamNumberOfEnum, chainable, this.chainSpec, validationContext, this.isDuckTyping, new ExprDotNodeFilterAnalyzerInputExpr());
            ExprEnumerationForge enumerationForge = null;
            EPChainableType type = rootEvalTypeNonEnum;
            if (!canEnum) {
                evals = chainEval.chainFor(rootEvalTypeNonEnum, null);
            } else {
                try {
                    evals = chainEval.chainFor(enumSrc.getReturnType(), enumSrc.getStreamOfProviderIfApplicable());
                    type = enumSrc.getReturnType();
                    enumerationForge = enumSrc.getEnumeration();
                }
                catch (ExprValidationException ex) {
                    if (this.isEnumerationMethod(this.chainSpec.get(0), validationContext)) {
                        throw ex;
                    }
                    try {
                        evals = chainEval.chainFor(rootEvalTypeNonEnum, null);
                    }
                    catch (ExprValidationException further) {
                        throw ex;
                    }
                }
            }
            this.forge = new ExprDotNodeForgeRootChild(this, null, null, null, hasEnumerationMethod, rootNode.getForge(), enumerationForge, type, evals.getChain(), evals.getChainWithUnpack(), false);
            return null;
        }
        if (this.chainSpec.size() == 1) {
            Chainable chainable2;
            chainable2 = this.chainSpec.get(0);
            if (!(chainable2 instanceof ChainableCall)) {
                throw new IllegalStateException("Unexpected chainable : " + chainable2);
            }
            ChainableCall call = (ChainableCall)chainable2;
            if (call.getParameters().isEmpty()) {
                throw this.handleNotFound(call.getName());
            }
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, call.getName(), streamTypeService.hasPropertyAgnosticType(), false, validationContext.getTableCompileTimeResolver());
            }
            catch (ExprValidationPropertyException rootEvalTypeNonEnum) {
                // empty catch block
            }
            if (propertyInfoPair == null && call.getName().toLowerCase(Locale.ENGLISH).equals("transpose")) {
                if (call.getParameters().size() != 1) {
                    throw new ExprValidationException("The transpose function requires a single parameter expression");
                }
                this.forge = new ExprDotNodeForgeTransposeAsStream(this, call.getParameters().get(0).getForge());
            } else {
                if (call.getParameters().size() != 1) {
                    throw this.handleNotFound(call.getName());
                }
                if (propertyInfoPair == null) {
                    throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + call.getName() + "' could not be resolved");
                }
                this.forge = this.getPropertyPairEvaluator(call.getParameters().get(0).getForge(), propertyInfoPair, validationContext);
            }
            return null;
        }
        ExprValidationException prefixedStreamNumException = null;
        int prefixedStreamNumber = this.prefixedStreamName(this.chainSpec, validationContext.getStreamTypeService());
        if (prefixedStreamNumber != -1) {
            ChainableName first = (ChainableName)this.chainSpec.get(0);
            Chainable specAfterStreamName = this.chainSpec.get(1);
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                String propName = first.getName() + "." + specAfterStreamName.getRootNameOrEmptyString();
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, propName, streamTypeService.hasPropertyAgnosticType(), true, validationContext.getTableCompileTimeResolver());
            }
            catch (ExprValidationPropertyException propName) {
                // empty catch block
            }
            if (propertyInfoPair != null) {
                ArrayList<Chainable> chain = new ArrayList<Chainable>(this.chainSpec);
                if (chain.size() == 2 && specAfterStreamName.getParametersOrEmpty().size() == 1) {
                    this.forge = this.getPropertyPairEvaluator(specAfterStreamName.getParametersOrEmpty().get(0).getForge(), propertyInfoPair, validationContext);
                    return null;
                }
                chain.remove(0);
                chain.remove(0);
                PropertyInfoPairDesc desc = ExprDotNodeImpl.handlePropertyInfoPair(true, specAfterStreamName, chain, propertyInfoPair, hasEnumerationMethod, validationContext, this);
                desc.apply(this);
                return null;
            }
            EventType eventType = validationContext.getStreamTypeService().getEventTypes()[prefixedStreamNumber];
            ArrayList<Chainable> remainderChain = new ArrayList<Chainable>(this.chainSpec);
            remainderChain.remove(0);
            ExprDotForge[] underlyingMethodChain = null;
            ExprValidationException underlyingMethodChainEx = null;
            if (eventType.getMetadata().getTypeClass() != EventTypeTypeClass.TABLE_PUBLIC && eventType.getMetadata().getTypeClass() != EventTypeTypeClass.TABLE_INTERNAL) {
                EPTypeClass type = eventType.getUnderlyingEPType();
                try {
                    EPChainableTypeClass typeInfo = new EPChainableTypeClass(type);
                    if (validationContext.getTableCompileTimeResolver().resolveTableFromEventType(eventType) != null) {
                        typeInfo = new EPChainableTypeClass(EPTypePremade.OBJECTARRAY.getEPType());
                    }
                    underlyingMethodChain = ExprDotNodeUtility.getChainEvaluators(prefixedStreamNumber, typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber)).getChainWithUnpack();
                }
                catch (ExprValidationException ex) {
                    underlyingMethodChainEx = ex;
                }
            }
            ExprDotForge[] eventTypeMethodChain = null;
            ExprValidationException eventTypeMethodChainEx = null;
            FilterExprAnalyzerAffector filterExprAnalyzerAffector = null;
            try {
                EPChainableType typeInfo = EPChainableTypeHelper.singleEvent(eventType);
                ExprDotNodeRealizedChain chain = ExprDotNodeUtility.getChainEvaluators(prefixedStreamNumber, typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber));
                eventTypeMethodChain = chain.getChainWithUnpack();
                filterExprAnalyzerAffector = chain.getFilterAnalyzerDesc();
            }
            catch (ExprValidationException ex) {
                eventTypeMethodChainEx = ex;
            }
            if (underlyingMethodChain != null) {
                this.forge = new ExprDotNodeForgeStream(this, filterExprAnalyzerAffector, prefixedStreamNumber, eventType, underlyingMethodChain, true);
            } else if (eventTypeMethodChain != null) {
                this.forge = new ExprDotNodeForgeStream(this, filterExprAnalyzerAffector, prefixedStreamNumber, eventType, eventTypeMethodChain, false);
            }
            if (this.forge != null) {
                return null;
            }
            String remainerName = ((Chainable)remainderChain.get(0)).getRootNameOrEmptyString();
            if (ExprDotNodeUtility.isDatetimeOrEnumMethod(remainerName, validationContext.getClasspathImportService())) {
                prefixedStreamNumException = eventTypeMethodChainEx;
            } else {
                String message = "Failed to solve '" + remainerName + "' to either an date-time or enumeration method, an event property or a method on the event underlying object";
                if (underlyingMethodChainEx != null) {
                    message = message + ": " + underlyingMethodChainEx.getMessage();
                }
                prefixedStreamNumException = new ExprValidationException(message, underlyingMethodChainEx);
            }
        }
        ArrayList<Chainable> modifiedChain = new ArrayList<Chainable>(this.chainSpec);
        Chainable firstItem = (Chainable)modifiedChain.remove(0);
        String firstItemName = firstItem.getRootNameOrEmptyString();
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
        try {
            propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, firstItemName, streamTypeService.hasPropertyAgnosticType(), true, validationContext.getTableCompileTimeResolver());
        }
        catch (ExprValidationPropertyException remainderChain) {
            // empty catch block
        }
        if (propertyInfoPair != null) {
            PropertyInfoPairDesc desc = ExprDotNodeImpl.handlePropertyInfoPair(false, firstItem, modifiedChain, propertyInfoPair, hasEnumerationMethod, validationContext, this);
            desc.apply(this);
            return null;
        }
        VariableMetaData variable = validationContext.getVariableCompileTimeResolver().resolve(firstItemName);
        if (variable != null) {
            ExprDotStaticMethodWrapArrayScalar wrap;
            EPChainableType typeInfo;
            if (variable.getOptionalContextName() != null) {
                throw new ExprValidationException("Method invocation on context-specific variable is not supported");
            }
            EPTypeClass variableType = variable.getType();
            if (variableType.getType().isArray()) {
                typeInfo = EPChainableTypeHelper.collectionOfSingleValue(JavaClassHelper.getArrayComponentType(variable.getType()));
                wrap = new ExprDotStaticMethodWrapArrayScalar(variable.getVariableName(), variable.getType());
            } else if (variable.getEventType() != null) {
                typeInfo = EPChainableTypeHelper.singleEvent(variable.getEventType());
                wrap = null;
            } else {
                typeInfo = EPChainableTypeHelper.singleValue(variableType);
                wrap = null;
            }
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.forge = new ExprDotNodeForgeVariable(this, variable, wrap, evals.getChainWithUnpack());
            return null;
        }
        ValueAndFieldDesc enumconstantDesc = ClasspathImportCompileTimeUtil.resolveIdentAsEnumConst(firstItemName, validationContext.getClasspathImportService(), validationContext.getClassProvidedClasspathExtension(), false);
        if (enumconstantDesc != null && modifiedChain.get(0) instanceof ChainableCall) {
            final ChainableCall methodSpec = (ChainableCall)modifiedChain.get(0);
            final String enumvalue = firstItemName;
            ExprNodeUtilResolveExceptionHandler handler = new ExprNodeUtilResolveExceptionHandler(){

                @Override
                public ExprValidationException handle(Exception ex) {
                    return new ExprValidationException("Failed to resolve method '" + methodSpec.getName() + "' on enumeration value '" + enumvalue + "': " + ex.getMessage());
                }
            };
            EventType wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
            EPTypeClass enumTypeClass = ClassHelperGenericType.getClassEPType(enumconstantDesc.getValue().getClass());
            ExprNodeUtilMethodDesc methodDesc = ExprNodeUtilityResolve.resolveMethodAllowWildcardAndStream(enumTypeClass.getType().getName(), enumTypeClass, methodSpec.getName(), methodSpec.getParameters(), wildcardType != null, wildcardType, handler, methodSpec.getName(), validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
            modifiedChain.remove(0);
            ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(methodDesc.getReflectionMethod(), modifiedChain, null, validationContext);
            EPTypeClass returnClass = ClassHelperGenericType.getMethodReturnEPType(methodDesc.getReflectionMethod());
            EPChainableType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : EPChainableTypeHelper.singleValue(returnClass);
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.forge = new ExprDotNodeForgeStaticMethod(this, false, firstItemName, methodDesc.getReflectionMethod(), methodDesc.getChildForges(), false, evals.getChainWithUnpack(), optionalLambdaWrap, false, enumconstantDesc, validationContext.getStatementName(), methodDesc.isLocalInlinedClass());
            return null;
        }
        if (prefixedStreamNumException != null) {
            throw prefixedStreamNumException;
        }
        Chainable secondItem = (Chainable)modifiedChain.remove(0);
        boolean allowWildcard = validationContext.getStreamTypeService().getEventTypes().length == 1;
        EventType streamZeroType = null;
        if (validationContext.getStreamTypeService().getEventTypes().length > 0) {
            streamZeroType = validationContext.getStreamTypeService().getEventTypes()[0];
        }
        ExprNodeUtilResolveExceptionHandlerDefault msgHandler = new ExprNodeUtilResolveExceptionHandlerDefault(firstItemName + (String)(secondItem.getRootNameOrEmptyString().isEmpty() ? "" : "." + secondItem.getRootNameOrEmptyString()), false);
        ExprNodeUtilMethodDesc method = ExprNodeUtilityResolve.resolveMethodAllowWildcardAndStream(firstItemName, null, secondItem.getRootNameOrEmptyString(), secondItem.getParametersOrEmpty(), allowWildcard, streamZeroType, msgHandler, secondItem.getRootNameOrEmptyString(), validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
        boolean isConstantParameters = method.isAllConstants() && this.isUDFCache;
        boolean isReturnsConstantResult = isConstantParameters && modifiedChain.isEmpty();
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(method.getReflectionMethod(), modifiedChain, null, validationContext);
        EPTypeClass returnClass = ClassHelperGenericType.getMethodReturnEPType(method.getReflectionMethod());
        EPChainableType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : EPChainableTypeHelper.singleValue(returnClass);
        ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
        this.forge = new ExprDotNodeForgeStaticMethod(this, isReturnsConstantResult, firstItemName, method.getReflectionMethod(), method.getChildForges(), isConstantParameters, evals.getChainWithUnpack(), optionalLambdaWrap, false, null, validationContext.getStatementName(), method.isLocalInlinedClass());
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PropertyInfoPairDesc handlePropertyInfoPair(boolean nestedComplexProperty, Chainable firstItem, List<Chainable> chain, Pair<PropertyResolutionDescriptor, String> propertyInfoPair, boolean hasEnumerationMethod, ExprValidationContext validationContext, ExprDotNodeImpl myself) throws ExprValidationException {
        void var13_24;
        ExprDotNodeRealizedChain evals;
        EPChainableType inputType;
        EventPropertyGetterSPI getter;
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        String propertyName = propertyInfoPair.getFirst().getPropertyName();
        int streamId = propertyInfoPair.getFirst().getStreamNum();
        EventTypeSPI streamType = (EventTypeSPI)streamTypeService.getEventTypes()[streamId];
        ExprEnumerationForge enumerationForge = null;
        Object var13_12 = null;
        boolean rootIsEventBean = false;
        if (firstItem instanceof ChainableName) {
            getter = streamType.getGetterSPI(propertyName);
            if (!(chain.get(0) instanceof ChainableArray)) {
                boolean allowEnum = nestedComplexProperty || hasEnumerationMethod;
                ExprDotEnumerationSourceForgeForProps propertyEval = ExprDotNodeUtility.getPropertyEnumerationSource(propertyName, streamId, streamType, allowEnum, validationContext.isDisablePropertyExpressionEventCollCache());
                enumerationForge = propertyEval.getEnumeration();
                inputType = propertyEval.getReturnType();
                propertyType = propertyInfoPair.getFirst().getPropertyType();
                EPTypeClass propertyTypeBoxed = ExprDotNodeImpl.boxedAndCheckNull(propertyType, propertyName);
                PropertyDotNonLambdaForge propertyDotNonLambdaForge = new PropertyDotNonLambdaForge(streamId, getter, propertyTypeBoxed);
            } else {
                ChainableArray array = (ChainableArray)chain.get(0);
                ExprNode indexExpression = ChainableArray.validateSingleIndexExpr(array.getIndexes(), () -> "property '" + propertyName + "'");
                propertyType = streamType.getPropertyEPType(propertyName);
                FragmentEventType fragmentEventType = streamType.getFragmentType(propertyName);
                if (fragmentEventType != null && fragmentEventType.isIndexed()) {
                    inputType = EPChainableTypeHelper.singleEvent(fragmentEventType.getFragmentType());
                    chain = chain.subList(1, chain.size());
                    PropertyDotNonLambdaFragmentIndexedForge propertyDotNonLambdaFragmentIndexedForge = new PropertyDotNonLambdaFragmentIndexedForge(streamId, getter, indexExpression, propertyName);
                    rootIsEventBean = true;
                } else {
                    if (!(propertyType instanceof EPTypeClass) || !((EPTypeClass)propertyType).getType().isArray()) throw new ExprValidationException("Invalid array operation for property '" + propertyName + "'");
                    inputType = EPChainableTypeHelper.singleValue(propertyType);
                    EPType propertyTypePair = propertyInfoPair.getFirst().getPropertyType();
                    EPTypeClass propertyTypeBoxed = ExprDotNodeImpl.boxedAndCheckNull(propertyTypePair, propertyName);
                    PropertyDotNonLambdaForge propertyDotNonLambdaForge = new PropertyDotNonLambdaForge(streamId, getter, propertyTypeBoxed);
                }
            }
        } else {
            getter = null;
            ChainableCall call = (ChainableCall)firstItem;
            EventPropertyDescriptor desc = EventTypeUtility.getNestablePropertyDescriptor(streamTypeService.getEventTypes()[propertyInfoPair.getFirst().getStreamNum()], call.getName());
            if (desc == null) {
                throw new IllegalStateException("Property descriptor for '" + call.getName() + "' is unexpectedly null");
            }
            if (call.getParameters().size() > 1) {
                throw new ExprValidationException("Property '" + call.getName() + "' may not be accessed passing 2 or more parameters");
            }
            ExprForge paramEval = call.getParameters().get(0).getForge();
            Class resultType = desc.getPropertyComponentType();
            if (desc.isMapped()) {
                if (!JavaClassHelper.isTypeString(paramEval.getEvaluationType())) {
                    throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a string-type value but returns " + paramEval.getEvaluationType().getTypeName());
                }
                EventPropertyGetterMappedSPI mappedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterMappedSPI(propertyName);
                if (mappedGetter == null) {
                    throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                }
                if (resultType != null) {
                    PropertyDotNonLambdaMappedForge propertyDotNonLambdaMappedForge = new PropertyDotNonLambdaMappedForge(streamId, mappedGetter, paramEval, desc.getPropertyComponentEPType());
                } else {
                    PropertyDotNonLambdaMappedForge propertyDotNonLambdaMappedForge = new PropertyDotNonLambdaMappedForge(streamId, mappedGetter, paramEval, (EPTypeClass)desc.getPropertyEPType());
                    resultType = desc.getPropertyType();
                }
            }
            if (desc.isIndexed()) {
                if (!JavaClassHelper.isTypeInteger(paramEval.getEvaluationType())) {
                    throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a Integer-type value but returns " + paramEval.getEvaluationType().getTypeName());
                }
                EventPropertyGetterIndexedSPI indexedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterIndexedSPI(propertyName);
                if (indexedGetter == null) {
                    throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                }
                PropertyDotNonLambdaIndexedForge propertyDotNonLambdaIndexedForge = new PropertyDotNonLambdaIndexedForge(streamId, indexedGetter, paramEval, desc.getPropertyComponentEPType());
            }
            inputType = new EPChainableTypeClass(resultType);
        }
        ExprDotNodeFilterAnalyzerInputProp filterAnalyzerInputProp = new ExprDotNodeFilterAnalyzerInputProp(propertyInfoPair.getFirst().getStreamNum(), propertyName);
        try {
            evals = ExprDotNodeUtility.getChainEvaluators(streamId, inputType, chain, validationContext, myself.isDuckTyping, filterAnalyzerInputProp);
        }
        catch (ExprValidationException ex) {
            EPChainableType fragmentTypeInfo;
            if (inputType instanceof EPChainableTypeEventSingle || inputType instanceof EPChainableTypeEventMulti) {
                throw ex;
            }
            FragmentEventType fragment = propertyInfoPair.getFirst().getFragmentEventType();
            if (fragment == null) {
                throw ex;
            }
            rootIsEventBean = true;
            if (!fragment.isIndexed()) {
                if (chain.get(0) instanceof ChainableArray) {
                    throw new ExprValidationException("Cannot perform array operation as property '" + propertyName + "' does not return an array");
                }
                fragmentTypeInfo = EPChainableTypeHelper.singleEvent(fragment.getFragmentType());
            } else {
                fragmentTypeInfo = EPChainableTypeHelper.arrayOfEvents(fragment.getFragmentType());
            }
            inputType = fragmentTypeInfo;
            PropertyDotNonLambdaFragmentForge propertyDotNonLambdaFragmentForge = new PropertyDotNonLambdaFragmentForge(streamId, getter, fragment.isIndexed());
            evals = ExprDotNodeUtility.getChainEvaluators(propertyInfoPair.getFirst().getStreamNum(), fragmentTypeInfo, chain, validationContext, myself.isDuckTyping, filterAnalyzerInputProp);
        }
        FilterExprAnalyzerAffector filterExprAnalyzerAffector = evals.getFilterAnalyzerDesc();
        int streamNumReferenced = propertyInfoPair.getFirst().getStreamNum();
        ExprDotNodeForgeRootChild forge = new ExprDotNodeForgeRootChild(myself, filterExprAnalyzerAffector, streamNumReferenced, propertyName, hasEnumerationMethod, (ExprForge)var13_24, enumerationForge, inputType, evals.getChain(), evals.getChainWithUnpack(), !rootIsEventBean);
        return new PropertyInfoPairDesc(forge);
    }

    private static EPTypeClass boxedAndCheckNull(EPType propertyType, String propertyName) throws ExprValidationException {
        if (propertyType == null || propertyType == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Property '" + propertyName + "' returns a null-type value");
        }
        return JavaClassHelper.getBoxedType((EPTypeClass)propertyType);
    }

    private Pair<ExprDotNodeAggregationMethodRootNode, List<Chainable>> handleAggregationMethod(ExprValidationContext validationContext) throws ExprValidationException {
        ExprDotNodeAggregationMethodForge aggregationMethodForge;
        Property prop;
        if (this.chainSpec.isEmpty() || this.getChildNodes().length == 0) {
            return null;
        }
        Chainable chainFirst = this.chainSpec.get(0);
        if (chainFirst instanceof ChainableArray) {
            return null;
        }
        ExprNode rootNode = this.getChildNodes()[0];
        ExprNode[] aggMethodParams = chainFirst.getParametersOrEmpty().toArray(new ExprNode[0]);
        String aggMethodName = chainFirst.getRootNameOrEmptyString();
        if (chainFirst instanceof ChainableName && (prop = PropertyParserNoDep.parseAndWalkLaxToSimple(chainFirst.getRootNameOrEmptyString(), false)) instanceof MappedProperty) {
            MappedProperty mappedProperty = (MappedProperty)prop;
            aggMethodName = mappedProperty.getPropertyNameAtomic();
            aggMethodParams = new ExprNode[]{new ExprConstantNodeImpl(mappedProperty.getKey())};
        }
        if (!(rootNode instanceof ExprTableAccessNodeSubprop || rootNode instanceof ExprAggMultiFunctionNode || rootNode instanceof ExprTableIdentNode)) {
            return null;
        }
        if (rootNode instanceof ExprAggMultiFunctionNode) {
            ExprAggMultiFunctionNode mf = (ExprAggMultiFunctionNode)rootNode;
            if (!mf.getAggregationForgeFactory().getAggregationPortableValidation().isAggregationMethod(aggMethodName, aggMethodParams, validationContext)) {
                return null;
            }
            aggregationMethodForge = new ExprDotNodeAggregationMethodForgeLocal(this, aggMethodName, aggMethodParams, mf.getAggregationForgeFactory().getAggregationPortableValidation(), mf);
        } else if (rootNode instanceof ExprTableIdentNode) {
            tableSubprop = (ExprTableIdentNode)rootNode;
            column = ((ExprTableIdentNode)tableSubprop).getTableMetadata().getColumns().get(((ExprTableIdentNode)tableSubprop).getColumnName());
            if (!(column instanceof TableMetadataColumnAggregation)) {
                return null;
            }
            TableMetadataColumnAggregation columnAggregation = (TableMetadataColumnAggregation)column;
            if (aggMethodName.toLowerCase(Locale.ENGLISH).equals("reset")) {
                if (!validationContext.isAllowTableAggReset()) {
                    throw new ExprValidationException("The table aggregation'reset' method is only available for the on-merge update action");
                }
                aggregationMethodForge = new ExprDotNodeAggregationMethodForgeTableReset(this, aggMethodName, aggMethodParams, columnAggregation.getAggregationPortableValidation(), (ExprTableIdentNode)tableSubprop, columnAggregation);
            } else {
                if (columnAggregation.isMethodAgg() || !columnAggregation.getAggregationPortableValidation().isAggregationMethod(aggMethodName, aggMethodParams, validationContext)) {
                    return null;
                }
                aggregationMethodForge = new ExprDotNodeAggregationMethodForgeTableIdent(this, aggMethodName, aggMethodParams, columnAggregation.getAggregationPortableValidation(), (ExprTableIdentNode)tableSubprop, columnAggregation);
            }
        } else if (rootNode instanceof ExprTableAccessNodeSubprop) {
            tableSubprop = (ExprTableAccessNodeSubprop)rootNode;
            column = ((ExprTableAccessNode)tableSubprop).getTableMeta().getColumns().get(((ExprTableAccessNodeSubprop)tableSubprop).getSubpropName());
            if (!(column instanceof TableMetadataColumnAggregation)) {
                return null;
            }
            TableMetadataColumnAggregation columnAggregation = (TableMetadataColumnAggregation)column;
            if (columnAggregation.isMethodAgg() || !columnAggregation.getAggregationPortableValidation().isAggregationMethod(aggMethodName, aggMethodParams, validationContext)) {
                return null;
            }
            aggregationMethodForge = new ExprDotNodeAggregationMethodForgeTableAccess(this, aggMethodName, aggMethodParams, columnAggregation.getAggregationPortableValidation(), (ExprTableAccessNodeSubprop)tableSubprop, columnAggregation);
        } else {
            throw new IllegalStateException("Unhandled aggregation method root node");
        }
        aggregationMethodForge.validate(validationContext);
        ArrayList<Chainable> newChain = this.chainSpec.size() == 1 ? Collections.emptyList() : new ArrayList<Chainable>(this.chainSpec.subList(1, this.chainSpec.size()));
        ExprDotNodeAggregationMethodRootNode root = new ExprDotNodeAggregationMethodRootNode(aggregationMethodForge);
        root.addChildNode(rootNode);
        return new Pair<ExprDotNodeAggregationMethodRootNode, List<Chainable>>(root, newChain);
    }

    @Override
    public FilterExprAnalyzerAffector getAffector(boolean isOuterJoin) {
        ExprDotNodeImpl.checkValidated(this.forge);
        return isOuterJoin ? null : this.forge.getFilterExprAnalyzerAffector();
    }

    private ExprDotNodeForge getPropertyPairEvaluator(ExprForge parameterForge, Pair<PropertyResolutionDescriptor, String> propertyInfoPair, ExprValidationContext validationContext) throws ExprValidationException {
        String propertyName = propertyInfoPair.getFirst().getPropertyName();
        EventPropertyDescriptor propertyDesc = EventTypeUtility.getNestablePropertyDescriptor(propertyInfoPair.getFirst().getStreamEventType(), propertyName);
        if (propertyDesc == null || !propertyDesc.isMapped() && !propertyDesc.isIndexed()) {
            throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + propertyName + "' could not be resolved");
        }
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        EventPropertyGetterMappedSPI mappedGetter = null;
        EventPropertyGetterIndexedSPI indexedGetter = null;
        EPTypeClass propertyType = EPTypePremade.OBJECT.getEPType();
        if (propertyDesc.isMapped()) {
            if (!JavaClassHelper.isTypeString(parameterForge.getEvaluationType())) {
                throw new ExprValidationException("Parameter expression to mapped property '" + propertyDesc.getPropertyName() + "' is expected to return a string-type value but returns " + parameterForge.getEvaluationType().getTypeName());
            }
            mappedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterMappedSPI(propertyInfoPair.getFirst().getPropertyName());
            if (mappedGetter == null) {
                throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
            }
        } else {
            if (!JavaClassHelper.isTypeInteger(parameterForge.getEvaluationType())) {
                throw new ExprValidationException("Parameter expression to indexed property '" + propertyDesc.getPropertyName() + "' is expected to return a Integer-type value but returns " + parameterForge.getEvaluationType().getTypeName());
            }
            indexedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterIndexedSPI(propertyInfoPair.getFirst().getPropertyName());
            if (indexedGetter == null) {
                throw new ExprValidationException("Indexed property named '" + propertyName + "' failed to obtain getter-object");
            }
        }
        if (propertyDesc.getPropertyComponentType() != null) {
            propertyType = JavaClassHelper.getBoxedType(propertyDesc.getPropertyComponentEPType());
        }
        return new ExprDotNodeForgePropertyExpr(this, validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterForge, propertyType, indexedGetter, mappedGetter);
    }

    private int prefixedStreamName(List<Chainable> chainSpec, StreamTypeService streamTypeService) {
        if (chainSpec.size() < 1) {
            return -1;
        }
        Chainable spec = chainSpec.get(0);
        if (!(spec instanceof ChainableName)) {
            return -1;
        }
        ChainableName name = (ChainableName)spec;
        return streamTypeService.getStreamNumForStreamName(name.getName());
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtilityModify.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    @Override
    public List<Chainable> getChainSpec() {
        return this.chainSpec;
    }

    @Override
    public void setChainSpec(List<Chainable> chainSpec) {
        this.chainSpec = Collections.unmodifiableList(chainSpec);
    }

    public ExprEvaluator getExprEvaluator() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    public boolean isConstantResult() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.isReturnsConstantResult();
    }

    @Override
    public ExprForge getForge() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.getStreamNumReferenced();
    }

    @Override
    public String getRootPropertyNameIfAny() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.getRootPropertyName();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        if (this.getChildNodes().length != 0) {
            writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.getChildNodes()[0]));
        }
        ExprNodeUtilityPrint.toExpressionString(this.chainSpec, writer, this.getChildNodes().length != 0, null);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprDotNodeImpl)) {
            return false;
        }
        ExprDotNodeImpl other = (ExprDotNodeImpl)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtilityQuery.collectChainParameters(this.chainSpec);
    }

    @Override
    public VariableMetaData isVariableOpGetName(VariableCompileTimeResolver variableCompileTimeResolver) {
        if (this.chainSpec.size() > 0 && this.chainSpec.get(0) instanceof ChainableName) {
            return variableCompileTimeResolver.resolve(((ChainableName)this.chainSpec.get(0)).getName());
        }
        return null;
    }

    private ExprValidationException handleNotFound(String name) {
        String appDotMethodDidYouMean = this.getAppDotMethodDidYouMean();
        String message = "Unknown single-row function, expression declaration, script or aggregation function named '" + name + "' could not be resolved";
        if (appDotMethodDidYouMean != null) {
            message = message + " (did you mean '" + appDotMethodDidYouMean + "')";
        }
        return new ExprValidationException(message);
    }

    private String getAppDotMethodDidYouMean() {
        String lhsName = this.chainSpec.get(0).getRootNameOrEmptyString().toLowerCase(Locale.ENGLISH);
        if (lhsName.equals("rectangle")) {
            return "rectangle.intersects";
        }
        if (lhsName.equals("point")) {
            return "point.inside";
        }
        return null;
    }

    private ExprAppDotMethodImpl getAppDotMethod(boolean filterExpression) throws ExprValidationException {
        boolean rectangleIntersectsRectangle;
        boolean rectangleIntersects;
        if (this.chainSpec.size() < 2) {
            return null;
        }
        if (!(this.chainSpec.get(1) instanceof ChainableCall)) {
            return null;
        }
        ChainableCall call = (ChainableCall)this.chainSpec.get(1);
        String lhsName = this.chainSpec.get(0).getRootNameOrEmptyString();
        String operationName = call.getName().toLowerCase(Locale.ENGLISH);
        boolean pointInside = lhsName.equals("point") && operationName.equals("inside");
        boolean bl = rectangleIntersects = lhsName.equals("rectangle") && operationName.equals("intersects");
        if (!pointInside && !rectangleIntersects) {
            return null;
        }
        if (call.getParameters().size() != 1) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        ExprNode param = call.getParameters().get(0);
        if (!(param instanceof ExprDotNode)) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        ExprDotNode compared = (ExprDotNode)call.getParameters().get(0);
        if (compared.getChainSpec().size() != 1) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        String rhsName = compared.getChainSpec().get(0).getRootNameOrEmptyString().toLowerCase(Locale.ENGLISH);
        boolean pointInsideRectangle = pointInside && rhsName.equals("rectangle");
        boolean bl2 = rectangleIntersectsRectangle = rectangleIntersects && rhsName.equals("rectangle");
        if (!pointInsideRectangle && !rectangleIntersectsRectangle) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        List<ExprNode> lhsExpressions = this.chainSpec.get(0).getParametersOrEmpty();
        ExprNode[] indexNamedParameter = null;
        ArrayList<ExprNode> lhsExpressionsValues = new ArrayList<ExprNode>();
        for (ExprNode lhsExpression : lhsExpressions) {
            if (lhsExpression instanceof ExprNamedParameterNode) {
                ExprNamedParameterNode named = (ExprNamedParameterNode)((Object)lhsExpression);
                if (named.getParameterName().toLowerCase(Locale.ENGLISH).equals("filterindex")) {
                    if (!filterExpression) {
                        throw new ExprValidationException("The '" + named.getParameterName() + "' named parameter can only be used in in filter expressions");
                    }
                    indexNamedParameter = named.getChildNodes();
                    continue;
                }
                throw new ExprValidationException(lhsName + " does not accept '" + named.getParameterName() + "' as a named parameter");
            }
            lhsExpressionsValues.add(lhsExpression);
        }
        ExprNode[] lhs = ExprNodeUtilityQuery.toArray(lhsExpressionsValues);
        ExprNode[] rhs = ExprNodeUtilityQuery.toArray(compared.getChainSpec().get(0).getParametersOrEmpty());
        SettingsApplicationDotMethodBase predefined = pointInsideRectangle ? new SettingsApplicationDotMethodPointInsideRectange(this, lhsName, lhs, operationName, rhsName, rhs, indexNamedParameter) : new SettingsApplicationDotMethodRectangeIntersectsRectangle(this, lhsName, lhs, operationName, rhsName, rhs, indexNamedParameter);
        return new ExprAppDotMethodImpl(predefined);
    }

    @Override
    public boolean isLocalInlinedClass() {
        return this.forge.isLocalInlinedClass();
    }

    private ExprValidationException getAppDocMethodException(String lhsName, String operationName) {
        return new ExprValidationException(lhsName + "." + operationName + " requires a single rectangle as parameter");
    }

    private boolean isEnumerationMethod(Chainable chainable, ExprValidationContext validationContext) throws ExprValidationException {
        if (!(chainable instanceof ChainableCall)) {
            return false;
        }
        ChainableCall call = (ChainableCall)chainable;
        return EnumMethodResolver.isEnumerationMethod(call.getName(), validationContext.getClasspathImportService());
    }

    private static interface ChainEval {
        public ExprDotNodeRealizedChain chainFor(EPChainableType var1, Integer var2) throws ExprValidationException;
    }

    private static class PropertyInfoPairDesc {
        private final ExprDotNodeForgeRootChild forge;

        public PropertyInfoPairDesc(ExprDotNodeForgeRootChild forge) {
            this.forge = forge;
        }

        public ExprDotNodeForgeRootChild getForge() {
            return this.forge;
        }

        public void apply(ExprDotNodeImpl node) {
            node.forge = this.forge;
        }
    }
}

