/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCompareEquals;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCaseNodeForge;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCaseNodeForgeEvalSyntax1;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;

public class ExprCaseNodeForgeEvalSyntax2
implements ExprEvaluator {
    private final ExprCaseNodeForge forge;
    private final List<UniformPair<ExprEvaluator>> whenThenNodeList;
    private final ExprEvaluator compareExprNode;
    private final ExprEvaluator optionalElseExprNode;

    ExprCaseNodeForgeEvalSyntax2(ExprCaseNodeForge forge, List<UniformPair<ExprEvaluator>> whenThenNodeList, ExprEvaluator compareExprNode, ExprEvaluator optionalElseExprNode) {
        this.forge = forge;
        this.whenThenNodeList = whenThenNodeList;
        this.compareExprNode = compareExprNode;
        this.optionalElseExprNode = optionalElseExprNode;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object checkResult = this.compareExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprEvaluator> p : this.whenThenNodeList) {
            Object whenResult = p.getFirst().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (!this.compare(checkResult, whenResult)) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.forge.getEvaluationType().getType() && this.forge.isNumericResult()) {
            caseResult = JavaClassHelper.coerceBoxed((Number)caseResult, this.forge.getEvaluationType().getType());
        }
        return caseResult;
    }

    public static CodegenExpression codegen(ExprCaseNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        EPTypeClass evaluationType = forge.getEvaluationType() == null ? EPTypePremade.MAP.getEPType() : forge.getEvaluationType();
        EPTypeClass compareType = (EPTypeClass)forge.getOptionalCompareExprNode().getForge().getEvaluationType();
        CodegenMethod methodNode = codegenMethodScope.makeChild(evaluationType, ExprCaseNodeForgeEvalSyntax2.class, (CodegenScope)codegenClassScope);
        EPTypeClass checkResultType = compareType == null ? EPTypePremade.OBJECT.getEPType() : compareType;
        CodegenBlock block = methodNode.getBlock().declareVar(checkResultType, "checkResult", forge.getOptionalCompareExprNode().getForge().evaluateCodegen(checkResultType, methodNode, exprSymbol, codegenClassScope));
        int num = 0;
        for (UniformPair<ExprNode> pair : forge.getWhenThenNodeList()) {
            String refname = "r" + num;
            EPType lhsType = pair.getFirst().getForge().getEvaluationType();
            EPTypeClass lhsTypeClass = lhsType == null || lhsType == EPTypeNull.INSTANCE ? null : (EPTypeClass)lhsType;
            EPTypeClass lhsDeclaredType = lhsTypeClass == null ? EPTypePremade.OBJECT.getEPType() : lhsTypeClass;
            block.declareVar(lhsDeclaredType, refname, pair.getFirst().getForge().evaluateCodegen(lhsDeclaredType, methodNode, exprSymbol, codegenClassScope));
            CodegenExpression compareExpression = ExprCaseNodeForgeEvalSyntax2.codegenCompare(CodegenExpressionBuilder.ref("checkResult"), compareType, CodegenExpressionBuilder.ref(refname), lhsTypeClass, forge, methodNode, codegenClassScope);
            block.ifCondition(compareExpression).blockReturn(ExprCaseNodeForgeEvalSyntax1.codegenToType(forge, pair.getSecond(), methodNode, exprSymbol, codegenClassScope));
            ++num;
        }
        if (forge.getOptionalElseExprNode() != null) {
            block.methodReturn(ExprCaseNodeForgeEvalSyntax1.codegenToType(forge, forge.getOptionalElseExprNode(), methodNode, exprSymbol, codegenClassScope));
        } else {
            block.methodReturn(CodegenExpressionBuilder.constantNull());
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    private boolean compare(Object leftResult, Object rightResult) {
        if (leftResult == null) {
            return rightResult == null;
        }
        if (rightResult == null) {
            return false;
        }
        if (!this.forge.isMustCoerce()) {
            return leftResult.equals(rightResult);
        }
        Number left = this.forge.getCoercer().coerceBoxed((Number)leftResult);
        Number right = this.forge.getCoercer().coerceBoxed((Number)rightResult);
        return left.equals(right);
    }

    private static CodegenExpression codegenCompare(CodegenExpressionRef lhs, EPType lhsType, CodegenExpressionRef rhs, EPType rhsType, ExprCaseNodeForge forge, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod method;
        if (lhsType == null || lhsType == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.equalsNull(rhs);
        }
        if (rhsType == null || rhsType == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.equalsNull(lhs);
        }
        EPTypeClass lhsClass = (EPTypeClass)lhsType;
        EPTypeClass rhsClass = (EPTypeClass)rhsType;
        if (lhsClass.getType().isPrimitive() && rhsClass.getType().isPrimitive() && !forge.isMustCoerce()) {
            return CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(lhs, lhsClass, rhs, rhsClass);
        }
        CodegenBlock block = codegenMethodScope.makeChild(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), ExprCaseNodeForgeEvalSyntax2.class, (CodegenScope)codegenClassScope).addParam(lhsClass, "leftResult").addParam(rhsClass, "rightResult").getBlock();
        if (!lhsClass.getType().isPrimitive()) {
            CodegenBlock ifBlock = block.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("leftResult")));
            if (rhsClass.getType().isPrimitive()) {
                ifBlock.blockReturn(CodegenExpressionBuilder.constantFalse());
            } else {
                ifBlock.blockReturn(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("rightResult")));
            }
        }
        if (!rhsClass.getType().isPrimitive()) {
            block.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("rightResult"))).blockReturn(CodegenExpressionBuilder.constantFalse());
        }
        if (!forge.isMustCoerce()) {
            method = block.methodReturn(CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(CodegenExpressionBuilder.ref("leftResult"), lhsClass, CodegenExpressionBuilder.ref("rightResult"), rhsClass));
        } else {
            block.declareVar(EPTypePremade.NUMBER.getEPType(), "left", forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref("leftResult"), lhsClass));
            block.declareVar(EPTypePremade.NUMBER.getEPType(), "right", forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref("rightResult"), rhsClass));
            method = block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("left"), "equals", CodegenExpressionBuilder.ref("right")));
        }
        return CodegenExpressionBuilder.localMethodBuild(method).pass(lhs).pass(rhs).call();
    }
}

