/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionLocalMethod;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCastNodeDateDesc;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCastNodeForge;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleISO8601Parser;
import com.espertech.esper.common.internal.schedule.ScheduleParameterException;
import com.espertech.esper.common.internal.settings.ClasspathImportEPTypeUtil;
import com.espertech.esper.common.internal.settings.RuntimeSettingsTimeZoneField;
import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import com.espertech.esper.common.internal.util.SimpleTypeCasterAnyType;
import com.espertech.esper.common.internal.util.SimpleTypeCasterFactory;
import com.espertech.esper.common.internal.util.SimpleTypeParserFactory;
import com.espertech.esper.common.internal.util.SimpleTypeParserSPI;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class ExprCastNode
extends ExprNodeBase {
    private final ClassDescriptor classIdentifierWArray;
    private ExprCastNodeForge forge;

    public ExprCastNode(ClassDescriptor classIdentifierWArray) {
        this.classIdentifierWArray = classIdentifierWArray;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge;
    }

    public ClassDescriptor getClassIdentifierWArray() {
        return this.classIdentifierWArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        void var10_42;
        void var10_37;
        SimpleTypeCaster caster;
        boolean numeric;
        if (this.getChildNodes().length == 0 || this.getChildNodes().length > 2) {
            throw new ExprValidationException("Cast function node must have one or two child expressions");
        }
        EPType fromType = this.getChildNodes()[0].getForge().getEvaluationType();
        EPType ePType = fromType == null ? EPTypeNull.INSTANCE : fromType;
        Map<String, ExprNamedParameterNode> namedParams = ExprNodeUtilityValidate.getNamedExpressionsHandleDups(Arrays.asList(this.getChildNodes()));
        ExprNodeUtilityValidate.validateNamed(namedParams, new String[]{"dateformat"});
        ExprNamedParameterNode dateFormatParameter = namedParams.get("dateformat");
        if (dateFormatParameter != null) {
            ExprNodeUtilityValidate.validateNamedExpectType(dateFormatParameter, new Class[]{String.class, DateFormat.class, DateTimeFormatter.class});
        }
        Class<?> clazzSimpleNamed = null;
        if (this.classIdentifierWArray.getTypeParameters().isEmpty()) {
            clazzSimpleNamed = JavaClassHelper.getPrimitiveClassForName(this.classIdentifierWArray.getClassIdentifier().trim());
        }
        EPTypeClass targetType = null;
        if (clazzSimpleNamed != null) {
            targetType = ClassHelperGenericType.getClassEPType(clazzSimpleNamed);
            if (!this.classIdentifierWArray.isArrayOfPrimitive()) {
                targetType = JavaClassHelper.getBoxedType(targetType);
            }
            targetType = this.applyDimensions(targetType);
        }
        Object var10_8 = null;
        String classIdentifierLower = this.classIdentifierWArray.getClassIdentifier().trim().toLowerCase(Locale.ENGLISH);
        if (dateFormatParameter != null) {
            if (!JavaClassHelper.isTypeString(ePType)) {
                throw new ExprValidationException("Use of the '" + dateFormatParameter.getParameterName() + "' named parameter requires a string-type input");
            }
            if (targetType == null) {
                try {
                    Class<?> targetClass = JavaClassHelper.getClassForName(this.classIdentifierWArray.getClassIdentifier().trim(), validationContext.getClasspathImportService().getClassForNameProvider());
                    targetType = this.applyDimensions(EPTypePremade.getOrCreate(targetClass));
                }
                catch (ClassNotFoundException targetClass) {
                    // empty catch block
                }
            }
            numeric = false;
            caster = null;
            if (targetType != null && targetType.getType() == Date.class || classIdentifierLower.equals("date")) {
                targetType = EPTypePremade.DATE.getEPType();
                desc = this.validateDateFormat(dateFormatParameter, validationContext, false);
                if (desc.isIso8601Format()) {
                    StringToDateWStaticISOFormatComputer stringToDateWStaticISOFormatComputer = new StringToDateWStaticISOFormatComputer();
                } else if (desc.getStaticDateFormatString() != null) {
                    StringToDateWStaticFormatComputer stringToDateWStaticFormatComputer = new StringToDateWStaticFormatComputer(desc.getStaticDateFormatString());
                } else {
                    StringToDateWExprFormatComputer stringToDateWExprFormatComputer = new StringToDateWExprFormatComputer(desc.getDynamicDateFormat(), desc.isDeployTimeConstant());
                }
            } else if (targetType != null && targetType.getType() == Calendar.class || classIdentifierLower.equals("calendar")) {
                targetType = EPTypePremade.CALENDAR.getEPType();
                desc = this.validateDateFormat(dateFormatParameter, validationContext, false);
                if (desc.isIso8601Format()) {
                    StringToCalendarWStaticISOFormatComputer stringToCalendarWStaticISOFormatComputer = new StringToCalendarWStaticISOFormatComputer();
                } else if (desc.getStaticDateFormatString() != null) {
                    StringToCalendarWStaticFormatComputer stringToCalendarWStaticFormatComputer = new StringToCalendarWStaticFormatComputer(desc.getStaticDateFormatString(), TimeZone.getDefault());
                } else {
                    StringToCalendarWExprFormatComputer stringToCalendarWExprFormatComputer = new StringToCalendarWExprFormatComputer(desc.getDynamicDateFormat(), TimeZone.getDefault());
                }
            } else if (targetType != null && targetType.getType() == Long.class) {
                targetType = EPTypePremade.LONGBOXED.getEPType();
                desc = this.validateDateFormat(dateFormatParameter, validationContext, false);
                if (desc.isIso8601Format()) {
                    StringToLongWStaticISOFormatComputer stringToLongWStaticISOFormatComputer = new StringToLongWStaticISOFormatComputer();
                } else if (desc.getStaticDateFormatString() != null) {
                    StringToLongWStaticFormatComputer stringToLongWStaticFormatComputer = new StringToLongWStaticFormatComputer(desc.getStaticDateFormatString());
                } else {
                    StringToLongWExprFormatComputerForge stringToLongWExprFormatComputerForge = new StringToLongWExprFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else if (targetType != null && targetType.getType() == LocalDateTime.class || classIdentifierLower.equals("localdatetime")) {
                targetType = EPTypePremade.LOCALDATETIME.getEPType();
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToLocalDateTimeIsoFormatComputer stringToLocalDateTimeIsoFormatComputer = new StringToLocalDateTimeIsoFormatComputer();
                } else if (desc.getStaticDateFormatString() != null) {
                    StringToLocalDateTimeWStaticFormatComputer stringToLocalDateTimeWStaticFormatComputer = new StringToLocalDateTimeWStaticFormatComputer(desc.getStaticDateFormatString());
                } else {
                    StringToLocalDateTimeWExprFormatComputerForge stringToLocalDateTimeWExprFormatComputerForge = new StringToLocalDateTimeWExprFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else if (targetType != null && targetType.getType() == LocalDate.class || classIdentifierLower.equals("localdate")) {
                targetType = EPTypePremade.LOCALDATE.getEPType();
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToLocalDateIsoFormatComputer stringToLocalDateIsoFormatComputer = new StringToLocalDateIsoFormatComputer();
                } else if (desc.getStaticDateFormatString() != null) {
                    StringToLocalDateWStaticFormatComputer stringToLocalDateWStaticFormatComputer = new StringToLocalDateWStaticFormatComputer(desc.getStaticDateFormatString());
                } else {
                    StringToLocalDateWExprFormatComputerForge stringToLocalDateWExprFormatComputerForge = new StringToLocalDateWExprFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else if (targetType != null && targetType.getType() == LocalTime.class || classIdentifierLower.equals("localtime")) {
                targetType = EPTypePremade.LOCALTIME.getEPType();
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToLocalTimeIsoFormatComputer stringToLocalTimeIsoFormatComputer = new StringToLocalTimeIsoFormatComputer();
                } else if (desc.getStaticDateFormatString() != null) {
                    StringToLocalTimeWStaticFormatComputer stringToLocalTimeWStaticFormatComputer = new StringToLocalTimeWStaticFormatComputer(desc.getStaticDateFormatString());
                } else {
                    StringToLocalTimeWExprFormatComputerForge stringToLocalTimeWExprFormatComputerForge = new StringToLocalTimeWExprFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else {
                if ((targetType == null || targetType.getType() != ZonedDateTime.class) && !classIdentifierLower.equals("zoneddatetime")) throw new ExprValidationException("Use of the '" + dateFormatParameter.getParameterName() + "' named parameter requires a target type of calendar, date, long, localdatetime, localdate, localtime or zoneddatetime");
                targetType = EPTypePremade.ZONEDDATETIME.getEPType();
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToZonedDateTimeIsoFormatComputer stringToZonedDateTimeIsoFormatComputer = new StringToZonedDateTimeIsoFormatComputer();
                } else if (desc.getStaticDateFormatString() != null) {
                    StringToZonedDateTimeWStaticFormatComputer stringToZonedDateTimeWStaticFormatComputer = new StringToZonedDateTimeWStaticFormatComputer(desc.getStaticDateFormatString());
                } else {
                    StringToZonedDateTimeWExprFormatComputerForge stringToZonedDateTimeWExprFormatComputerForge = new StringToZonedDateTimeWExprFormatComputerForge(desc.getDynamicDateFormat());
                }
            }
        } else if (targetType != null) {
            targetType = JavaClassHelper.getBoxedType(targetType);
            caster = SimpleTypeCasterFactory.getCaster(ePType, targetType);
            numeric = caster.isNumericCast();
        } else if (classIdentifierLower.equals("BigInteger".toLowerCase(Locale.ENGLISH))) {
            targetType = EPTypePremade.BIGINTEGER.getEPType();
            targetType = this.applyDimensions(targetType);
            caster = SimpleTypeCasterFactory.getCaster(ePType, targetType);
            numeric = true;
        } else if (classIdentifierLower.equals("BigDecimal".toLowerCase(Locale.ENGLISH))) {
            targetType = EPTypePremade.BIGDECIMAL.getEPType();
            targetType = this.applyDimensions(targetType);
            caster = SimpleTypeCasterFactory.getCaster(ePType, targetType);
            numeric = true;
        } else {
            targetType = ClasspathImportEPTypeUtil.resolveClassIdentifierToEPType(this.classIdentifierWArray, false, validationContext.getClasspathImportService(), validationContext.getClassProvidedClasspathExtension());
            if (targetType == null) {
                throw new ExprValidationException("Class as listed in cast function by name '" + this.classIdentifierWArray.toEPL() + "' cannot be found");
            }
            numeric = JavaClassHelper.isNumeric(targetType);
            caster = numeric ? SimpleTypeCasterFactory.getCaster(ePType, targetType) : new SimpleTypeCasterAnyType(targetType);
        }
        if (var10_37 == null) {
            if (targetType.getType() == String.class) {
                StringXFormComputer stringXFormComputer = new StringXFormComputer();
            } else if (JavaClassHelper.isTypeString(ePType) && targetType.getType() != Character.class) {
                SimpleTypeParserSPI parser = SimpleTypeParserFactory.getParser(JavaClassHelper.getBoxedType(targetType).getType());
                StringParserComputer stringParserComputer = new StringParserComputer(parser);
            } else if (numeric) {
                NumberCasterComputer numberCasterComputer = new NumberCasterComputer(caster);
            } else {
                NonnumericCasterComputer nonnumericCasterComputer = new NonnumericCasterComputer(caster);
            }
        }
        Object theConstant = null;
        boolean isConstant = false;
        if (this.getChildNodes()[0].getForge().getForgeConstantType().isCompileTimeConstant() && (isConstant = var10_42.isConstantForConstInput())) {
            Object in = this.getChildNodes()[0].getForge().getExprEvaluator().evaluate(null, true, null);
            theConstant = in == null ? null : var10_42.getEvaluatorComputer().compute(in, null, true, null);
        }
        this.forge = new ExprCastNodeForge(this, (CasterParserComputerForge)var10_42, targetType, isConstant, theConstant);
        return null;
    }

    public boolean isConstantResult() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge.isConstant();
    }

    public Class getTargetType() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge.getEvaluationType().getType();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append("cast(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(",");
        this.classIdentifierWArray.toEPL(writer);
        for (int i = 1; i < this.getChildNodes().length; ++i) {
            writer.write(",");
            this.getChildNodes()[i].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprCastNode)) {
            return false;
        }
        ExprCastNode other = (ExprCastNode)node;
        return other.classIdentifierWArray.equals(this.classIdentifierWArray);
    }

    public static EPException handleParseException(DateFormat format, String date, Exception ex) {
        String pattern = format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : format.toString();
        return ExprCastNode.handleParseException(pattern, date, ex);
    }

    public static EPException handleParseException(String formatString, String date, Exception ex) {
        return new EPException("Exception parsing date '" + date + "' format '" + formatString + "': " + ex.getMessage(), ex);
    }

    public static EPException handleParseISOException(String date, ScheduleParameterException ex) {
        return new EPException("Exception parsing iso8601 date '" + date + "': " + ex.getMessage(), ex);
    }

    private ExprCastNodeDateDesc validateDateFormat(ExprNamedParameterNode dateFormatParameter, ExprValidationContext validationContext, boolean java8Formatter) throws ExprValidationException {
        boolean iso8601Format = false;
        ExprNode formatExpr = dateFormatParameter.getChildNodes()[0];
        ExprForge formatForge = formatExpr.getForge();
        EPType formatReturnType = formatExpr.getForge().getEvaluationType();
        String staticFormatString = null;
        if (formatReturnType == null || formatReturnType == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Invalid null value for date format");
        }
        EPTypeClass typeClass = (EPTypeClass)formatReturnType;
        if (typeClass.getType() == String.class) {
            if (formatExpr.getForge().getForgeConstantType().isCompileTimeConstant()) {
                staticFormatString = (String)formatForge.getExprEvaluator().evaluate(null, true, null);
                if (staticFormatString.toLowerCase(Locale.ENGLISH).trim().equals("iso")) {
                    iso8601Format = true;
                } else if (!java8Formatter) {
                    try {
                        new SimpleDateFormat(staticFormatString);
                    }
                    catch (RuntimeException ex) {
                        throw new ExprValidationException("Invalid date format '" + staticFormatString + "' (as obtained from new SimpleDateFormat): " + ex.getMessage(), ex);
                    }
                } else {
                    try {
                        DateTimeFormatter.ofPattern(staticFormatString);
                    }
                    catch (RuntimeException ex) {
                        throw new ExprValidationException("Invalid date format '" + staticFormatString + "' (as obtained from DateTimeFormatter.ofPattern): " + ex.getMessage(), ex);
                    }
                }
            }
        } else if (!java8Formatter) {
            if (!JavaClassHelper.isSubclassOrImplementsInterface((EPType)typeClass, DateFormat.class)) {
                throw this.getFailedExpected(DateFormat.class, formatReturnType);
            }
        } else if (!JavaClassHelper.isSubclassOrImplementsInterface((EPType)typeClass, DateTimeFormatter.class)) {
            throw this.getFailedExpected(DateTimeFormatter.class, formatReturnType);
        }
        return new ExprCastNodeDateDesc(iso8601Format, formatForge, staticFormatString, formatForge.getForgeConstantType().isConstant());
    }

    public static SimpleDateFormat stringToSimpleDateFormatSafe(Object format) {
        if (format == null) {
            throw new EPException("Null date format returned by 'dateformat' expression");
        }
        try {
            return new SimpleDateFormat(format.toString());
        }
        catch (RuntimeException ex) {
            throw new EPException("Invalid date format '" + format.toString() + "': " + ex.getMessage(), ex);
        }
    }

    public static DateTimeFormatter stringToDateTimeFormatterSafe(Object format) {
        if (format == null) {
            throw new EPException("Null date format returned by 'dateformat' expression");
        }
        try {
            return DateTimeFormatter.ofPattern(format.toString());
        }
        catch (RuntimeException ex) {
            throw new EPException("Invalid date format '" + format.toString() + "': " + ex.getMessage(), ex);
        }
    }

    private static CodegenExpression formatFieldJava7(String dateFormatString, CodegenClassScope codegenClassScope) {
        return codegenClassScope.addFieldUnshared(true, EPTypePremade.DATEFORMAT.getEPType(), CodegenExpressionBuilder.newInstance(EPTypePremade.SIMPLEDATEFORMAT.getEPType(), CodegenExpressionBuilder.constant(dateFormatString)));
    }

    private static CodegenExpression formatFieldJava8(String dateFormatString, CodegenClassScope codegenClassScope) {
        return codegenClassScope.addFieldUnshared(true, EPTypePremade.STRING.getEPType(), CodegenExpressionBuilder.staticMethod(DateTimeFormatter.class, "ofPattern", CodegenExpressionBuilder.constant(dateFormatString)));
    }

    private static CodegenExpression formatFieldExpr(EPTypeClass type, ExprForge formatExpr, CodegenClassScope codegenClassScope) {
        CodegenMethod formatEval = CodegenLegoMethodExpression.codegenExpression(formatExpr, codegenClassScope.getPackageScope().getInitMethod(), codegenClassScope);
        CodegenExpressionLocalMethod formatInit = CodegenExpressionBuilder.localMethod(formatEval, CodegenExpressionBuilder.constantNull(), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull());
        return codegenClassScope.addFieldUnshared(true, type, formatInit);
    }

    private ExprValidationException getFailedExpected(Class expected, EPType received) {
        return new ExprValidationException("Invalid format, expected string-format or " + expected.getSimpleName() + " but received " + received.getTypeName());
    }

    private EPTypeClass applyDimensions(EPTypeClass targetType) {
        if (targetType == null) {
            return null;
        }
        if (this.classIdentifierWArray.getArrayDimensions() == 0) {
            return targetType;
        }
        return JavaClassHelper.getArrayType(targetType, this.classIdentifierWArray.getArrayDimensions());
    }

    public static class StringToDateWStaticISOFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        public static Date stringToDateWStaticISOParse(String input) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input).getTime();
            }
            catch (ScheduleParameterException e) {
                throw ExprCastNode.handleParseISOException(input, e);
            }
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToDateWStaticISOFormatComputer.stringToDateWStaticISOParse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToDateWStaticISOFormatComputer.class, "stringToDateWStaticISOParse", input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringToDateWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        public StringToDateWStaticFormatComputer(String dateFormatString) {
            super(dateFormatString);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToDateWStaticFormatComputer.stringToDateWStaticFormatParseSafe(new SimpleDateFormat(this.dateFormatString), input);
        }

        public static Date stringToDateWStaticFormatParseSafe(DateFormat format, Object input) {
            try {
                return format.parse(input.toString());
            }
            catch (ParseException e) {
                throw ExprCastNode.handleParseException(format, input.toString(), (Exception)e);
            }
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToDateWStaticFormatComputer.class, "stringToDateWStaticFormatParseSafe", ExprCastNode.formatFieldJava7(this.dateFormatString, codegenClassScope), input);
        }
    }

    public static class StringToDateWExprFormatComputer
    extends StringToDateLongWExprFormatForge {
        public StringToDateWExprFormatComputer(ExprForge dateFormatForge, boolean deployTimeConstant) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToDateExprFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToDateExprFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToCalendarWStaticISOFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        public static Calendar stringToCalendarWStaticISOParse(String input) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input);
            }
            catch (ScheduleParameterException ex) {
                throw ExprCastNode.handleParseISOException(input, ex);
            }
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToCalendarWStaticISOFormatComputer.stringToCalendarWStaticISOParse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToCalendarWStaticISOFormatComputer.class, "stringToCalendarWStaticISOParse", input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringToCalendarWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        private final TimeZone timeZone;

        public StringToCalendarWStaticFormatComputer(String dateFormatString, TimeZone timeZone) {
            super(dateFormatString);
            this.timeZone = timeZone;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToCalendarWStaticFormatComputer.stringToCalendarWStaticFormatParse(new SimpleDateFormat(this.dateFormatString), input, this.timeZone);
        }

        public static Calendar stringToCalendarWStaticFormatParse(DateFormat format, Object input, TimeZone timeZone) {
            try {
                Calendar cal = Calendar.getInstance(timeZone);
                Date date = format.parse(input.toString());
                cal.setTime(date);
                return cal;
            }
            catch (ParseException ex) {
                throw ExprCastNode.handleParseException(format, input.toString(), (Exception)ex);
            }
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
            return CodegenExpressionBuilder.staticMethod(StringToCalendarWStaticFormatComputer.class, "stringToCalendarWStaticFormatParse", ExprCastNode.formatFieldJava7(this.dateFormatString, codegenClassScope), input, timeZoneField);
        }
    }

    public static class StringToCalendarWExprFormatComputer
    extends StringToDateLongWExprFormatForge {
        private final TimeZone timeZone;

        public StringToCalendarWExprFormatComputer(ExprForge dateFormatForge, TimeZone timeZone) {
            super(dateFormatForge);
            this.timeZone = timeZone;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToCalendarWExprFormatComputerEval(this.dateFormatForge.getExprEvaluator(), this.timeZone);
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToCalendarWExprFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope, this.timeZone);
        }
    }

    public static class StringToLongWStaticISOFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        public static long stringToLongWStaticISOParse(String input) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input).getTimeInMillis();
            }
            catch (ScheduleParameterException ex) {
                throw ExprCastNode.handleParseISOException(input, ex);
            }
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLongWStaticISOFormatComputer.stringToLongWStaticISOParse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLongWStaticISOFormatComputer.class, "stringToLongWStaticISOParse", input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringToLongWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        public StringToLongWStaticFormatComputer(String dateFormatString) {
            super(dateFormatString);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLongWStaticFormatComputer.stringToLongWStaticFormatParseSafe(new SimpleDateFormat(this.dateFormatString), input);
        }

        public static long stringToLongWStaticFormatParseSafe(DateFormat format, Object input) {
            try {
                return format.parse(input.toString()).getTime();
            }
            catch (ParseException e) {
                throw ExprCastNode.handleParseException(format, input.toString(), (Exception)e);
            }
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLongWStaticFormatComputer.class, "stringToLongWStaticFormatParseSafe", ExprCastNode.formatFieldJava7(this.dateFormatString, codegenClassScope), input);
        }
    }

    public static class StringToLongWExprFormatComputerForge
    extends StringToDateLongWExprFormatForge {
        public StringToLongWExprFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLongWExprFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLongWExprFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToLocalDateTimeIsoFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalDateTimeWStaticFormatComputer.class, "stringToLocalDateTimeWStaticFormatParse", input, CodegenExpressionBuilder.publicConstValue(DateTimeFormatter.class, "ISO_DATE_TIME"));
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLocalDateTimeWStaticFormatComputer.stringToLocalDateTimeWStaticFormatParse(input.toString(), DateTimeFormatter.ISO_DATE_TIME);
        }
    }

    public static class StringToLocalDateTimeWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToLocalDateTimeWStaticFormatComputer(String format) {
            super(format);
        }

        public static LocalDateTime stringToLocalDateTimeWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return LocalDateTime.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, (Exception)e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToLocalDateTimeWStaticFormatComputer.stringToLocalDateTimeWStaticFormatParse(input, DateTimeFormatter.ofPattern(this.format));
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalDateTimeWStaticFormatComputer.class, "stringToLocalDateTimeWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static class StringToLocalDateTimeWExprFormatComputerForge
    extends StringToJava8WExprFormatComputerForge {
        public StringToLocalDateTimeWExprFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLocalDateTimeWExprFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLocalDateTimeWExprFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToLocalDateIsoFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalDateWStaticFormatComputer.class, "stringToLocalDateWStaticFormatParse", input, CodegenExpressionBuilder.publicConstValue(DateTimeFormatter.class, "ISO_DATE"));
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLocalDateWStaticFormatComputer.stringToLocalDateWStaticFormatParse(input.toString(), DateTimeFormatter.ISO_DATE);
        }
    }

    public static class StringToLocalDateWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToLocalDateWStaticFormatComputer(String format) {
            super(format);
        }

        public static LocalDate stringToLocalDateWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return LocalDate.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, (Exception)e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToLocalDateWStaticFormatComputer.stringToLocalDateWStaticFormatParse(input, DateTimeFormatter.ofPattern(this.format));
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalDateWStaticFormatComputer.class, "stringToLocalDateWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static class StringToLocalDateWExprFormatComputerForge
    extends StringToJava8WExprFormatComputerForge {
        public StringToLocalDateWExprFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLocalDateWExprFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLocalDateWExprFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToLocalTimeIsoFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalTimeWStaticFormatComputer.class, "stringToLocalTimeWStaticFormatParse", input, CodegenExpressionBuilder.publicConstValue(DateTimeFormatter.class, "ISO_TIME"));
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLocalTimeWStaticFormatComputer.stringToLocalTimeWStaticFormatParse(input.toString(), DateTimeFormatter.ISO_TIME);
        }
    }

    public static class StringToLocalTimeWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToLocalTimeWStaticFormatComputer(String format) {
            super(format);
        }

        public static LocalTime stringToLocalTimeWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return LocalTime.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, (Exception)e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToLocalTimeWStaticFormatComputer.stringToLocalTimeWStaticFormatParse(input, DateTimeFormatter.ofPattern(this.format));
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalTimeWStaticFormatComputer.class, "stringToLocalTimeWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static class StringToLocalTimeWExprFormatComputerForge
    extends StringToJava8WExprFormatComputerForge {
        public StringToLocalTimeWExprFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLocalTimeWExprFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLocalTimeWExprFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToZonedDateTimeIsoFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToZonedDateTimeWStaticFormatComputer.class, "stringZonedDateTimeWStaticFormatParse", input, CodegenExpressionBuilder.publicConstValue(DateTimeFormatter.class, "ISO_ZONED_DATE_TIME"));
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToZonedDateTimeWStaticFormatComputer.stringZonedDateTimeWStaticFormatParse(input.toString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
    }

    public static class StringToZonedDateTimeWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToZonedDateTimeWStaticFormatComputer(String format) {
            super(format);
        }

        public static ZonedDateTime stringZonedDateTimeWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return ZonedDateTime.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, (Exception)e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToZonedDateTimeWStaticFormatComputer.stringZonedDateTimeWStaticFormatParse(input, DateTimeFormatter.ofPattern(this.format));
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToZonedDateTimeWStaticFormatComputer.class, "stringZonedDateTimeWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static class StringToZonedDateTimeWExprFormatComputerForge
    extends StringToJava8WExprFormatComputerForge {
        public StringToZonedDateTimeWExprFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToZonedDateTimeWExprFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToZonedDateTimeWExprFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringXFormComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return input.toString();
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.exprDotMethod(input, "toString", new CodegenExpression[0]);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringParserComputer
    implements CasterParserComputer,
    CasterParserComputerForge {
        private final SimpleTypeParserSPI parser;

        public StringParserComputer(SimpleTypeParserSPI parser) {
            this.parser = parser;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.parser.parse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.parser.codegen(input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class NumberCasterComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        private final SimpleTypeCaster numericTypeCaster;

        public NumberCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.numericTypeCaster = numericTypeCaster;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            if (input instanceof Number) {
                return this.numericTypeCaster.cast(input);
            }
            return null;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            if (inputType.getType().isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface((EPType)inputType, Number.class)) {
                return this.numericTypeCaster.codegen(input, inputType, codegenMethodScope, codegenClassScope);
            }
            CodegenMethod methodNode = codegenMethodScope.makeChild(evaluationType, NumberCasterComputer.class, (CodegenScope)codegenClassScope).addParam(inputType, "input");
            methodNode.getBlock().ifInstanceOf("input", EPTypePremade.NUMBER.getEPType()).blockReturn(this.numericTypeCaster.codegen(CodegenExpressionBuilder.ref("input"), inputType, methodNode, codegenClassScope)).methodReturn(CodegenExpressionBuilder.constantNull());
            return CodegenExpressionBuilder.localMethod(methodNode, input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class NonnumericCasterComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        private final SimpleTypeCaster caster;

        public NonnumericCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.caster = numericTypeCaster;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.caster.cast(input);
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(EPTypeClass evaluationType, CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.caster.codegen(input, inputType, codegenMethodScope, codegenClassScope);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static interface CasterParserComputerForge {
        public boolean isConstantForConstInput();

        public CodegenExpression codegenPremade(EPTypeClass var1, CodegenExpression var2, EPTypeClass var3, CodegenMethodScope var4, ExprForgeCodegenSymbol var5, CodegenClassScope var6);

        public CasterParserComputer getEvaluatorComputer();
    }

    public static interface CasterParserComputer {
        public Object compute(Object var1, EventBean[] var2, boolean var3, ExprEvaluatorContext var4);
    }

    public static class StringToCalendarWExprFormatComputerEval
    extends StringToDateLongWExprormatEval {
        private final TimeZone timeZone;

        public StringToCalendarWExprFormatComputerEval(ExprEvaluator dateFormatEval, TimeZone timeZone) {
            super(dateFormatEval);
            this.timeZone = timeZone;
        }

        @Override
        public Calendar compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            SimpleDateFormat dateFormat = ExprCastNode.stringToSimpleDateFormatSafe(format);
            return StringToCalendarWStaticFormatComputer.stringToCalendarWStaticFormatParse(dateFormat, input, this.timeZone);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, TimeZone timeZone) {
            CodegenExpression format;
            CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.CALENDAR.getEPType(), StringToCalendarWExprFormatComputerEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "input");
            if (dateFormatForge.getForgeConstantType().isConstant()) {
                format = ExprCastNode.formatFieldExpr(EPTypePremade.DATEFORMAT.getEPType(), dateFormatForge, codegenClassScope);
            } else {
                method.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "format", dateFormatForge.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), method, exprSymbol, codegenClassScope)).declareVar(EPTypePremade.SIMPLEDATEFORMAT.getEPType(), "dateFormat", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToSimpleDateFormatSafe", CodegenExpressionBuilder.ref("format")));
                format = CodegenExpressionBuilder.ref("dateFormat");
            }
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(StringToCalendarWStaticFormatComputer.class, "stringToCalendarWStaticFormatParse", format, CodegenExpressionBuilder.ref("input"), timeZoneField));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToLongWExprFormatComputerEval
    extends StringToDateLongWExprormatEval {
        public StringToLongWExprFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public Long compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            SimpleDateFormat dateFormat = ExprCastNode.stringToSimpleDateFormatSafe(format);
            return StringToLongWStaticFormatComputer.stringToLongWStaticFormatParseSafe(dateFormat, input);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge formatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpression format;
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.LONGBOXED.getEPType(), StringToLongWExprFormatComputerEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "input");
            if (formatForge.getForgeConstantType().isConstant()) {
                format = ExprCastNode.formatFieldExpr(EPTypePremade.DATEFORMAT.getEPType(), formatForge, codegenClassScope);
            } else {
                method.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "format", formatForge.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), method, exprSymbol, codegenClassScope)).declareVar(EPTypePremade.SIMPLEDATEFORMAT.getEPType(), "dateFormat", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToSimpleDateFormatSafe", CodegenExpressionBuilder.ref("format")));
                format = CodegenExpressionBuilder.ref("dateFormat");
            }
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(StringToLongWStaticFormatComputer.class, "stringToLongWStaticFormatParseSafe", format, CodegenExpressionBuilder.ref("input")));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToDateExprFormatComputerEval
    extends StringToDateLongWExprormatEval {
        public StringToDateExprFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public Date compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            SimpleDateFormat dateFormat = ExprCastNode.stringToSimpleDateFormatSafe(format);
            return StringToDateWStaticFormatComputer.stringToDateWStaticFormatParseSafe(dateFormat, input);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge formatExpr, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpression dateFormat;
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.DATE.getEPType(), StringToDateExprFormatComputerEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "input");
            if (formatExpr.getForgeConstantType().isConstant()) {
                dateFormat = ExprCastNode.formatFieldExpr(EPTypePremade.DATEFORMAT.getEPType(), formatExpr, codegenClassScope);
            } else {
                method.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "format", formatExpr.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), method, exprSymbol, codegenClassScope)).declareVar(EPTypePremade.SIMPLEDATEFORMAT.getEPType(), "dateFormat", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToSimpleDateFormatSafe", CodegenExpressionBuilder.ref("format")));
                dateFormat = CodegenExpressionBuilder.ref("dateFormat");
            }
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(StringToDateWStaticFormatComputer.class, "stringToDateWStaticFormatParseSafe", dateFormat, CodegenExpressionBuilder.ref("input")));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToZonedDateTimeWExprFormatComputerEval
    extends StringToJava8WExprFormatComputerEval {
        public StringToZonedDateTimeWExprFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public ZonedDateTime compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToZonedDateTimeWStaticFormatComputer.stringZonedDateTimeWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpression format;
            CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.ZONEDDATETIME.getEPType(), StringToZonedDateTimeWExprFormatComputerEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.STRING.getEPType(), "input");
            if (dateFormatForge.getForgeConstantType().isConstant()) {
                format = ExprCastNode.formatFieldExpr(EPTypePremade.DATETIMEFORMATTER.getEPType(), dateFormatForge, codegenClassScope);
            } else {
                methodNode.getBlock().declareVar(EPTypePremade.DATETIMEFORMATTER.getEPType(), "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), methodNode, exprSymbol, codegenClassScope)));
                format = CodegenExpressionBuilder.ref("formatter");
            }
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(StringToZonedDateTimeWStaticFormatComputer.class, "stringZonedDateTimeWStaticFormatParse", CodegenExpressionBuilder.ref("input"), format));
            return CodegenExpressionBuilder.localMethod(methodNode, input);
        }
    }

    public static class StringToLocalTimeWExprFormatComputerEval
    extends StringToJava8WExprFormatComputerEval {
        public StringToLocalTimeWExprFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public LocalTime compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToLocalTimeWStaticFormatComputer.stringToLocalTimeWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpression format;
            CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.LOCALTIME.getEPType(), StringToLocalTimeWExprFormatComputerForge.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.STRING.getEPType(), "input");
            if (dateFormatForge.getForgeConstantType().isConstant()) {
                format = ExprCastNode.formatFieldExpr(EPTypePremade.DATETIMEFORMATTER.getEPType(), dateFormatForge, codegenClassScope);
            } else {
                methodNode.getBlock().declareVar(EPTypePremade.DATETIMEFORMATTER.getEPType(), "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), methodNode, exprSymbol, codegenClassScope)));
                format = CodegenExpressionBuilder.ref("formatter");
            }
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(StringToLocalTimeWStaticFormatComputer.class, "stringToLocalTimeWStaticFormatParse", CodegenExpressionBuilder.ref("input"), format));
            return CodegenExpressionBuilder.localMethod(methodNode, input);
        }
    }

    public static class StringToLocalDateWExprFormatComputerEval
    extends StringToJava8WExprFormatComputerEval {
        public StringToLocalDateWExprFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public LocalDate compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToLocalDateWStaticFormatComputer.stringToLocalDateWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpression format;
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.LOCALDATE.getEPType(), StringToLocalDateWExprFormatComputerEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.STRING.getEPType(), "input");
            if (dateFormatForge.getForgeConstantType().isConstant()) {
                format = ExprCastNode.formatFieldExpr(EPTypePremade.DATETIMEFORMATTER.getEPType(), dateFormatForge, codegenClassScope);
            } else {
                method.getBlock().declareVar(EPTypePremade.DATETIMEFORMATTER.getEPType(), "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), method, exprSymbol, codegenClassScope)));
                format = CodegenExpressionBuilder.ref("formatter");
            }
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(StringToLocalDateWStaticFormatComputer.class, "stringToLocalDateWStaticFormatParse", CodegenExpressionBuilder.ref("input"), format));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToLocalDateTimeWExprFormatComputerEval
    extends StringToJava8WExprFormatComputerEval {
        public StringToLocalDateTimeWExprFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToLocalDateTimeWStaticFormatComputer.stringToLocalDateTimeWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpression formatter;
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.LOCALDATETIME.getEPType(), StringToLocalDateTimeWExprFormatComputerEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.STRING.getEPType(), "input");
            if (dateFormatForge.getForgeConstantType().isConstant()) {
                formatter = ExprCastNode.formatFieldExpr(EPTypePremade.DATETIMEFORMATTER.getEPType(), dateFormatForge, codegenClassScope);
            } else {
                method.getBlock().declareVar(EPTypePremade.DATETIMEFORMATTER.getEPType(), "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), method, exprSymbol, codegenClassScope)));
                formatter = CodegenExpressionBuilder.ref("formatter");
            }
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(StringToLocalDateTimeWStaticFormatComputer.class, "stringToLocalDateTimeWStaticFormatParse", CodegenExpressionBuilder.ref("input"), formatter));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static abstract class StringToJava8WExprFormatComputerEval
    implements CasterParserComputer {
        protected final ExprEvaluator dateFormatEval;

        public StringToJava8WExprFormatComputerEval(ExprEvaluator dateFormatEval) {
            this.dateFormatEval = dateFormatEval;
        }
    }

    public static abstract class StringToJava8WExprFormatComputerForge
    implements CasterParserComputerForge {
        protected final ExprForge dateFormatForge;

        public StringToJava8WExprFormatComputerForge(ExprForge dateFormatForge) {
            this.dateFormatForge = dateFormatForge;
        }

        @Override
        public boolean isConstantForConstInput() {
            return false;
        }
    }

    public static abstract class StringToJava8WStaticFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        protected final String format;

        public StringToJava8WStaticFormatComputer(String format) {
            this.format = format;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        public abstract Object parse(String var1);

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.parse(input.toString());
        }

        protected CodegenExpression codegenFormatter(CodegenClassScope codegenClassScope) {
            return codegenClassScope.addFieldUnshared(true, EPTypePremade.DATETIMEFORMATTER.getEPType(), CodegenExpressionBuilder.staticMethod(DateTimeFormatter.class, "ofPattern", CodegenExpressionBuilder.constant(this.format)));
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static abstract class StringToDateLongWExprormatEval
    implements CasterParserComputer {
        protected final ExprEvaluator dateFormatEval;

        public StringToDateLongWExprormatEval(ExprEvaluator dateFormatEval) {
            this.dateFormatEval = dateFormatEval;
        }
    }

    public static abstract class StringToDateLongWExprFormatForge
    implements CasterParserComputerForge {
        protected final ExprForge dateFormatForge;

        protected StringToDateLongWExprFormatForge(ExprForge dateFormatForge) {
            this.dateFormatForge = dateFormatForge;
        }

        @Override
        public boolean isConstantForConstInput() {
            return false;
        }
    }

    public static abstract class StringToDateLongWStaticFormat
    implements CasterParserComputerForge,
    CasterParserComputer {
        protected final String dateFormatString;

        public StringToDateLongWStaticFormat(String dateFormatString) {
            this.dateFormatString = dateFormatString;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }
}

