/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCoalesceNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;

public class ExprCoalesceNodeForgeEval
implements ExprEvaluator {
    private final ExprCoalesceNodeForge forge;
    private final ExprEvaluator[] evaluators;

    ExprCoalesceNodeForgeEval(ExprCoalesceNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (int i = 0; i < this.evaluators.length; ++i) {
            Object value = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (value == null) continue;
            if (this.forge.getIsNumericCoercion()[i]) {
                value = JavaClassHelper.coerceBoxed((Number)value, ((EPTypeClass)this.forge.getEvaluationType()).getType());
            }
            return value;
        }
        return null;
    }

    public static CodegenExpression codegen(ExprCoalesceNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (forge.getEvaluationType() == null || forge.getEvaluationType() == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPTypeClass evaluationClass = (EPTypeClass)forge.getEvaluationType();
        CodegenMethod methodNode = codegenMethodScope.makeChild((EPTypeClass)forge.getEvaluationType(), ExprCoalesceNodeForgeEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock();
        int num = 0;
        boolean doneWithReturn = false;
        for (ExprNode node : forge.getForgeRenderable().getChildNodes()) {
            EPType evaltype = node.getForge().getEvaluationType();
            if (evaltype != null && evaltype != EPTypeNull.INSTANCE) {
                EPTypeClass classtype = (EPTypeClass)evaltype;
                String refname = "r" + num;
                block.declareVar(classtype, refname, node.getForge().evaluateCodegen(classtype, methodNode, exprSymbol, codegenClassScope));
                if (classtype.getType().isPrimitive()) {
                    if (!forge.getIsNumericCoercion()[num]) {
                        block.methodReturn(CodegenExpressionBuilder.ref(refname));
                        doneWithReturn = true;
                        break;
                    }
                    SimpleNumberCoercer coercer = SimpleNumberCoercerFactory.getCoercer(classtype, evaluationClass);
                    block.methodReturn(coercer.coerceCodegen(CodegenExpressionBuilder.ref(refname), classtype));
                    doneWithReturn = true;
                    break;
                }
                CodegenBlock blockIf = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
                if (!forge.getIsNumericCoercion()[num]) {
                    blockIf.blockReturn(CodegenExpressionBuilder.ref(refname));
                } else {
                    blockIf.blockReturn(JavaClassHelper.coerceNumberBoxedToBoxedCodegen(CodegenExpressionBuilder.ref(refname), classtype, (EPTypeClass)forge.getEvaluationType()));
                }
            }
            ++num;
        }
        if (!doneWithReturn) {
            block.methodReturn(CodegenExpressionBuilder.constantNull());
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

