/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprInstanceofNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExprInstanceofNodeForgeEval
implements ExprEvaluator {
    private final ExprInstanceofNodeForge forge;
    private final ExprEvaluator evaluator;
    private final CopyOnWriteArrayList<Pair<Class, Boolean>> resultCache = new CopyOnWriteArrayList();

    public ExprInstanceofNodeForgeEval(ExprInstanceofNodeForge forge, ExprEvaluator evaluator) {
        this.forge = forge;
        this.evaluator = evaluator;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object result = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (result == null) {
            return false;
        }
        return ExprInstanceofNodeForgeEval.instanceofCacheCheckOrAdd(this.forge.getClasses(), this.resultCache, result);
    }

    public static Boolean instanceofCacheCheckOrAdd(Class[] classes, CopyOnWriteArrayList<Pair<Class, Boolean>> resultCache, Object result) {
        for (Pair<Class, Boolean> pair : resultCache) {
            if (pair.getFirst() != result.getClass()) continue;
            return pair.getSecond();
        }
        Boolean out = ExprInstanceofNodeForgeEval.checkAddType(classes, result.getClass(), resultCache);
        return out;
    }

    public static CodegenExpression codegen(ExprInstanceofNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField cache = codegenClassScope.addFieldUnshared(true, EPTypePremade.COPYONWRITEARRAYLIST.getEPType(), CodegenExpressionBuilder.newInstance(EPTypePremade.COPYONWRITEARRAYLIST.getEPType(), new CodegenExpression[0]));
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), ExprInstanceofNodeForgeEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "result", forge.getForgeRenderable().getChildNodes()[0].getForge().evaluateCodegen(EPTypePremade.OBJECT.getEPType(), methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnFalse("result");
        block.methodReturn(CodegenExpressionBuilder.staticMethod(ExprInstanceofNodeForgeEval.class, "instanceofCacheCheckOrAdd", CodegenExpressionBuilder.constant(forge.getClasses()), cache, CodegenExpressionBuilder.ref("result")));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean checkAddType(Class[] classes, Class type, CopyOnWriteArrayList<Pair<Class, Boolean>> resultCache) {
        CopyOnWriteArrayList<Pair<Class, Boolean>> copyOnWriteArrayList = resultCache;
        synchronized (copyOnWriteArrayList) {
            for (Pair<Class, Boolean> pair : resultCache) {
                if (pair.getFirst() != type) continue;
                return pair.getSecond();
            }
            HashSet<Class> classesToCheck = new HashSet<Class>();
            JavaClassHelper.getSuper(type, classesToCheck);
            classesToCheck.add(type);
            boolean fits = false;
            for (Class clazz : classes) {
                if (!classesToCheck.contains(clazz)) continue;
                fits = true;
                break;
            }
            resultCache.add(new Pair<Class, Boolean>(type, fits));
            return fits;
        }
    }
}

