/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.MinMaxTypeEnum;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprMinMaxRowNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExprMinMaxRowNodeForgeEval
implements ExprEvaluator {
    private final ExprMinMaxRowNodeForge forge;
    private final MinMaxTypeEnum.Computer computer;

    public ExprMinMaxRowNodeForgeEval(ExprMinMaxRowNodeForge forge, ExprEvaluator[] evaluators, ExprForge[] forges) {
        this.forge = forge;
        if (forge.getEvaluationType().getType() == BigInteger.class) {
            SimpleNumberBigIntegerCoercer[] convertors = new SimpleNumberBigIntegerCoercer[evaluators.length];
            for (int i = 0; i < evaluators.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigInteger((EPTypeClass)forges[i].getEvaluationType());
            }
            this.computer = new MinMaxTypeEnum.ComputerBigIntCoerce(evaluators, convertors, forge.getForgeRenderable().getMinMaxTypeEnum() == MinMaxTypeEnum.MAX);
        } else if (forge.getEvaluationType().getType() == BigDecimal.class) {
            SimpleNumberBigDecimalCoercer[] convertors = new SimpleNumberBigDecimalCoercer[evaluators.length];
            for (int i = 0; i < evaluators.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigDecimal((EPTypeClass)forges[i].getEvaluationType());
            }
            this.computer = new MinMaxTypeEnum.ComputerBigDecCoerce(evaluators, convertors, forge.getForgeRenderable().getMinMaxTypeEnum() == MinMaxTypeEnum.MAX);
        } else {
            this.computer = forge.getForgeRenderable().getMinMaxTypeEnum() == MinMaxTypeEnum.MAX ? new MinMaxTypeEnum.MaxComputerDoubleCoerce(evaluators) : new MinMaxTypeEnum.MinComputerDoubleCoerce(evaluators);
        }
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Number result = this.computer.execute(eventsPerStream, isNewData, exprEvaluatorContext);
        if (result == null) {
            return null;
        }
        return JavaClassHelper.coerceBoxed(result, this.forge.getEvaluationType().getType());
    }

    public static CodegenExpression codegen(ExprMinMaxRowNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression expression;
        EPTypeClass resultType = forge.getEvaluationType();
        ExprNode[] nodes = forge.getForgeRenderable().getChildNodes();
        if (resultType.getType() == BigInteger.class) {
            SimpleNumberBigIntegerCoercer[] convertors = new SimpleNumberBigIntegerCoercer[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigInteger((EPTypeClass)nodes[i].getForge().getEvaluationType());
            }
            expression = MinMaxTypeEnum.ComputerBigIntCoerce.codegen(forge.getForgeRenderable().getMinMaxTypeEnum() == MinMaxTypeEnum.MAX, codegenMethodScope, exprSymbol, codegenClassScope, nodes, convertors);
        } else if (resultType.getType() == BigDecimal.class) {
            SimpleNumberBigDecimalCoercer[] convertors = new SimpleNumberBigDecimalCoercer[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigDecimal((EPTypeClass)nodes[i].getForge().getEvaluationType());
            }
            expression = MinMaxTypeEnum.ComputerBigDecCoerce.codegen(forge.getForgeRenderable().getMinMaxTypeEnum() == MinMaxTypeEnum.MAX, codegenMethodScope, exprSymbol, codegenClassScope, nodes, convertors);
        } else {
            expression = forge.getForgeRenderable().getMinMaxTypeEnum() == MinMaxTypeEnum.MAX ? MinMaxTypeEnum.MaxComputerDoubleCoerce.codegen(codegenMethodScope, exprSymbol, codegenClassScope, nodes, resultType) : MinMaxTypeEnum.MinComputerDoubleCoerce.codegen(codegenMethodScope, exprSymbol, codegenClassScope, nodes, resultType);
        }
        return expression;
    }
}

