/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprTypeofNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprTypeofNodeForge;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;

public class ExprTypeofNodeForgeFragmentType
extends ExprTypeofNodeForge
implements ExprEvaluator {
    private final ExprTypeofNode parent;
    private final int streamId;
    private final EventPropertyGetterSPI getter;
    private final String fragmentType;

    public ExprTypeofNodeForgeFragmentType(ExprTypeofNode parent, int streamId, EventPropertyGetterSPI getter, String fragmentType) {
        this.parent = parent;
        this.streamId = streamId;
        this.getter = getter;
        this.fragmentType = fragmentType;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean event = eventsPerStream[this.streamId];
        if (event == null) {
            return null;
        }
        Object fragment = this.getter.getFragment(event);
        if (fragment == null) {
            return null;
        }
        if (fragment instanceof EventBean) {
            EventBean bean = (EventBean)fragment;
            return bean.getEventType().getName();
        }
        if (fragment.getClass().isArray()) {
            String type = this.fragmentType + "[]";
            return type;
        }
        return null;
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprTypeof", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.STRING.getEPType(), ExprTypeofNodeForgeFragmentType.class, (CodegenScope)codegenClassScope);
        CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
        methodNode.getBlock().declareVar(EventBean.EPTYPE, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamId))).ifRefNullReturnNull("event").declareVar(EPTypePremade.OBJECT.getEPType(), "fragment", this.getter.eventBeanFragmentCodegen(CodegenExpressionBuilder.ref("event"), methodNode, codegenClassScope)).ifRefNullReturnNull("fragment").ifInstanceOf("fragment", EventBean.EPTYPE).blockReturn(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.cast(EventBean.EPTYPE, (CodegenExpression)CodegenExpressionBuilder.ref("fragment"))).add("getEventType", new CodegenExpression[0]).add("getName", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("fragment")).add("getClass", new CodegenExpression[0]).add("isArray", new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(this.fragmentType + "[]")).methodReturn(CodegenExpressionBuilder.constantNull());
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this.parent;
    }
}

