/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprBitWiseNodeForge;
import com.espertech.esper.common.internal.type.BitWiseOpEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprBitWiseNode
extends ExprNodeBase {
    private final BitWiseOpEnum bitWiseOpEnum;
    private transient ExprBitWiseNodeForge forge;

    public ExprBitWiseNode(BitWiseOpEnum bitWiseOpEnum) {
        this.bitWiseOpEnum = bitWiseOpEnum;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprBitWiseNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprBitWiseNode.checkValidated(this.forge);
        return this.forge;
    }

    public BitWiseOpEnum getBitWiseOpEnum() {
        return this.bitWiseOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("BitWise node must have 2 parameters");
        }
        EPType lhsType = this.getChildNodes()[0].getForge().getEvaluationType();
        EPType rhsType = this.getChildNodes()[1].getForge().getEvaluationType();
        this.checkNumericOrBoolean(lhsType);
        this.checkNumericOrBoolean(rhsType);
        EPTypeClass lhsTypeClass = JavaClassHelper.getBoxedType((EPTypeClass)lhsType);
        EPTypeClass rhsTypeClass = JavaClassHelper.getBoxedType((EPTypeClass)rhsType);
        if (JavaClassHelper.isFloatingPointClass(lhsTypeClass) || JavaClassHelper.isFloatingPointClass(rhsTypeClass)) {
            throw new ExprValidationException("Invalid type for bitwise " + this.bitWiseOpEnum.getComputeDescription() + " operator");
        }
        if (!lhsTypeClass.equals(rhsTypeClass)) {
            throw new ExprValidationException("Bitwise expressions must be of the same type for bitwise " + this.bitWiseOpEnum.getComputeDescription() + " operator");
        }
        BitWiseOpEnum.Computer computer = this.bitWiseOpEnum.getComputer(lhsTypeClass.getType());
        this.forge = new ExprBitWiseNodeForge(this, lhsTypeClass, computer);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprBitWiseNode)) {
            return false;
        }
        ExprBitWiseNode other = (ExprBitWiseNode)node;
        return other.bitWiseOpEnum == this.bitWiseOpEnum;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        writer.append(this.bitWiseOpEnum.getComputeDescription());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence(), flags);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.BITWISE;
    }

    private void checkNumericOrBoolean(EPType childType) throws ExprValidationException {
        if (childType == null || childType == EPTypeNull.INSTANCE || !JavaClassHelper.isTypeBoolean(childType) && !JavaClassHelper.isNumeric(childType)) {
            throw new ExprValidationException("Invalid datatype for binary operator, " + (childType == null ? "null" : childType.getTypeName()) + " is not allowed");
        }
    }
}

