/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprBitWiseNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class ExprBitWiseNodeForgeEval
implements ExprEvaluator {
    private final ExprBitWiseNodeForge forge;
    private final ExprEvaluator lhs;
    private final ExprEvaluator rhs;

    ExprBitWiseNodeForgeEval(ExprBitWiseNodeForge forge, ExprEvaluator lhs, ExprEvaluator rhs) {
        this.forge = forge;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object left = this.lhs.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object right = this.rhs.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (left == null || right == null) {
            return null;
        }
        return this.forge.getComputer().compute(left, right);
    }

    public static CodegenExpression codegen(ExprBitWiseNodeForge forge, EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode lhs, ExprNode rhs) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(forge.getEvaluationType(), ExprBitWiseNodeForgeEval.class, (CodegenScope)codegenClassScope);
        EPTypeClass leftType = (EPTypeClass)lhs.getForge().getEvaluationType();
        EPTypeClass rightType = (EPTypeClass)rhs.getForge().getEvaluationType();
        CodegenBlock block = methodNode.getBlock().declareVar(leftType, "left", lhs.getForge().evaluateCodegen(leftType, methodNode, exprSymbol, codegenClassScope)).declareVar(rightType, "right", rhs.getForge().evaluateCodegen(rightType, methodNode, exprSymbol, codegenClassScope));
        if (!leftType.getType().isPrimitive()) {
            block.ifRefNullReturnNull("left");
        }
        if (!rightType.getType().isPrimitive()) {
            block.ifRefNullReturnNull("right");
        }
        EPTypeClass primitive = JavaClassHelper.getPrimitiveType(forge.getEvaluationType());
        block.declareVar(primitive, "l", (CodegenExpression)CodegenExpressionBuilder.ref("left")).declareVar(primitive, "r", (CodegenExpression)CodegenExpressionBuilder.ref("right"));
        block.methodReturn(CodegenExpressionBuilder.cast(primitive, CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("l"), forge.getForgeRenderable().getBitWiseOpEnum().getExpressionText(), CodegenExpressionBuilder.ref("r"))));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

