/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.ThreadingProfile;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.ops.ExprConcatNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprConcatNodeForgeEvalThreadLocal;
import com.espertech.esper.common.internal.epl.expression.ops.ExprConcatNodeForgeEvalWNew;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;

public class ExprConcatNodeForge
implements ExprForgeInstrumentable {
    private final ExprConcatNode parent;
    private final ThreadingProfile threadingProfile;

    public ExprConcatNodeForge(ExprConcatNode parent, ThreadingProfile threadingProfile) {
        this.parent = parent;
        this.threadingProfile = threadingProfile;
    }

    @Override
    public ExprConcatNode getForgeRenderable() {
        return this.parent;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        ExprEvaluator[] evaluators = ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.parent.getChildNodes());
        if (this.threadingProfile == ThreadingProfile.LARGE) {
            return new ExprConcatNodeForgeEvalWNew(this, evaluators);
        }
        return new ExprConcatNodeForgeEvalThreadLocal(this, evaluators);
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprConcat", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprConcatNodeForgeEvalWNew.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public EPTypeClass getEvaluationType() {
        return EPTypePremade.STRING.getEPType();
    }
}

