/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeForgeCoercion;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeForgeNC;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.Map;

public class ExprEqualsNodeImpl
extends ExprNodeBase
implements ExprEqualsNode {
    private final boolean isNotEquals;
    private final boolean isIs;
    private transient ExprEqualsNodeForge forge;

    public ExprEqualsNodeImpl(boolean isNotEquals, boolean isIs) {
        this.isNotEquals = isNotEquals;
        this.isIs = isIs;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprEqualsNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprEqualsNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        EPTypeClass coercionType;
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Invalid use of equals, expecting left-hand side and right-hand side but received " + this.getChildNodes().length + " expressions");
        }
        ExprNode lhs = this.getChildNodes()[0];
        ExprNode rhs = this.getChildNodes()[1];
        EPType lhsType = lhs.getForge().getEvaluationType();
        EPType rhsType = rhs.getForge().getEvaluationType();
        if (lhsType == null || lhsType == EPTypeNull.INSTANCE || rhsType == null || rhsType == EPTypeNull.INSTANCE) {
            this.forge = new ExprEqualsNodeForgeNC(this);
            return null;
        }
        EPTypeClass lhsClass = (EPTypeClass)lhsType;
        EPTypeClass rhsClass = (EPTypeClass)rhsType;
        if ((lhsClass = JavaClassHelper.getBoxedType(lhsClass)).equals(rhsClass = JavaClassHelper.getBoxedType(rhsClass)) || lhsClass.getType().isAssignableFrom(rhsClass.getType())) {
            this.forge = new ExprEqualsNodeForgeNC(this);
            return null;
        }
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(lhsClass, rhsClass);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + rhsClass + "' to '" + lhsClass + "' is not allowed");
        }
        if (coercionType == JavaClassHelper.getBoxedType(lhsClass) && coercionType == JavaClassHelper.getBoxedType(rhsClass)) {
            this.forge = new ExprEqualsNodeForgeNC(this);
        } else {
            if (!JavaClassHelper.isNumeric(coercionType)) {
                throw new ExprValidationException("Cannot convert datatype '" + coercionType.getTypeName() + "' to a value that fits both type '" + lhsClass.getTypeName() + "' and type '" + rhsClass.getTypeName() + "'");
            }
            SimpleNumberCoercer numberCoercerLHS = SimpleNumberCoercerFactory.getCoercer(lhsClass, coercionType);
            SimpleNumberCoercer numberCoercerRHS = SimpleNumberCoercerFactory.getCoercer(rhsClass, coercionType);
            this.forge = new ExprEqualsNodeForgeCoercion(this, numberCoercerLHS, numberCoercerRHS, lhsClass, rhsClass);
        }
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        if (this.isIs) {
            writer.append(" is ");
            if (this.isNotEquals) {
                writer.append("not ");
            }
        } else if (!this.isNotEquals) {
            writer.append("=");
        } else {
            writer.append("!=");
        }
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence(), flags);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.EQUALS;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprEqualsNode)) {
            return false;
        }
        ExprEqualsNode other = (ExprEqualsNode)node;
        return other.isNotEquals() == this.isNotEquals;
    }

    @Override
    public boolean isNotEquals() {
        return this.isNotEquals;
    }

    @Override
    public boolean isIs() {
        return this.isIs;
    }
}

