/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNodeForgeEvalNoColl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNodeForgeEvalWColl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNodeImpl;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;

public class ExprInNodeForge
implements ExprForgeInstrumentable {
    private final ExprInNodeImpl parent;
    private final boolean mustCoerce;
    private final SimpleNumberCoercer coercer;
    private final EPTypeClass coercionType;
    private final boolean hasCollectionOrArray;

    public ExprInNodeForge(ExprInNodeImpl parent, boolean mustCoerce, SimpleNumberCoercer coercer, EPTypeClass coercionType, boolean hasCollectionOrArray) {
        this.parent = parent;
        this.mustCoerce = mustCoerce;
        this.coercer = coercer;
        this.coercionType = coercionType;
        this.hasCollectionOrArray = hasCollectionOrArray;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        ExprEvaluator[] evaluators = ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.parent.getChildNodes());
        if (this.hasCollectionOrArray) {
            return new ExprInNodeForgeEvalWColl(this, evaluators);
        }
        return new ExprInNodeForgeEvalNoColl(this, evaluators);
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprInNodeForgeEvalWColl.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprIn", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public EPTypeClass getEvaluationType() {
        return EPTypePremade.BOOLEANBOXED.getEPType();
    }

    @Override
    public ExprInNodeImpl getForgeRenderable() {
        return this.parent;
    }

    public boolean isMustCoerce() {
        return this.mustCoerce;
    }

    public SimpleNumberCoercer getCoercer() {
        return this.coercer;
    }

    public EPTypeClass getCoercionType() {
        return this.coercionType;
    }

    public boolean isHasCollectionOrArray() {
        return this.hasCollectionOrArray;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }
}

