/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprOrNodeEval;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprOrNode
extends ExprNodeBase
implements ExprForgeInstrumentable {
    @Override
    public EPTypeClass getEvaluationType() {
        return EPTypePremade.BOOLEANBOXED.getEPType();
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return new ExprOrNodeEval(this, ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.getChildNodes()));
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprOrNodeEval.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprOr", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprNode child : this.getChildNodes()) {
            if (JavaClassHelper.isTypeBoolean(child.getForge().getEvaluationType())) continue;
            throw new ExprValidationException("Incorrect use of OR clause, sub-expressions do not return boolean");
        }
        if (this.getChildNodes().length <= 1) {
            throw new ExprValidationException("The OR operator requires at least 2 child expressions");
        }
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        String appendStr = "";
        for (ExprNode child : this.getChildNodes()) {
            writer.append(appendStr);
            child.toEPL(writer, this.getPrecedence(), flags);
            appendStr = " or ";
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.OR;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprOrNode;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }
}

