/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpAllAnyNodeForge;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class ExprRelationalOpAllAnyNodeForgeEval
implements ExprEvaluator {
    private final ExprRelationalOpAllAnyNodeForge forge;
    private final ExprEvaluator[] evaluators;

    public ExprRelationalOpAllAnyNodeForgeEval(ExprRelationalOpAllAnyNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateInternal(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    private Boolean evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.evaluators.length == 1) {
            return false;
        }
        boolean isAll = this.forge.getForgeRenderable().isAll();
        RelationalOpEnum.Computer computer = this.forge.getComputer();
        Object valueLeft = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        int len = this.evaluators.length - 1;
        if (this.forge.isHasCollectionOrArray()) {
            boolean hasNonNullRow = false;
            boolean hasRows = false;
            for (int i = 1; i <= len; ++i) {
                Object valueRight = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueRight == null) continue;
                if (valueRight instanceof Collection) {
                    Collection coll = (Collection)valueRight;
                    hasRows = true;
                    for (Object item : coll) {
                        if (!(item instanceof Number)) {
                            if (!isAll || item != null) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (isAll) {
                            if (computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (valueRight instanceof Map) {
                    Map coll = (Map)valueRight;
                    hasRows = true;
                    for (Object item : coll.keySet()) {
                        if (!(item instanceof Number)) {
                            if (!isAll || item != null) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (isAll) {
                            if (computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (valueRight.getClass().isArray()) {
                    hasRows = true;
                    int arrayLength = Array.getLength(valueRight);
                    for (int index = 0; index < arrayLength; ++index) {
                        Object item;
                        item = Array.get(valueRight, index);
                        if (item == null) {
                            if (!isAll) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (isAll) {
                            if (computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(valueRight instanceof Number)) {
                    if (!isAll) continue;
                    return null;
                }
                hasNonNullRow = true;
                if (isAll) {
                    if (computer.compare(valueLeft, valueRight)) continue;
                    return false;
                }
                if (!computer.compare(valueLeft, valueRight)) continue;
                return true;
            }
            if (isAll) {
                if (!hasRows) {
                    return true;
                }
                if (!hasNonNullRow || valueLeft == null) {
                    return null;
                }
                return true;
            }
            if (!hasRows) {
                return false;
            }
            if (!hasNonNullRow || valueLeft == null) {
                return null;
            }
            return false;
        }
        boolean hasNonNullRow = false;
        boolean hasRows = false;
        for (int i = 1; i <= len; ++i) {
            Object valueRight = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            hasRows = true;
            if (valueRight != null) {
                hasNonNullRow = true;
            } else if (isAll) {
                return null;
            }
            if (valueRight == null || valueLeft == null) continue;
            if (isAll) {
                if (computer.compare(valueLeft, valueRight)) continue;
                return false;
            }
            if (!computer.compare(valueLeft, valueRight)) continue;
            return true;
        }
        if (isAll) {
            if (!hasRows) {
                return true;
            }
            if (!hasNonNullRow || valueLeft == null) {
                return null;
            }
            return true;
        }
        if (!hasRows) {
            return false;
        }
        if (!hasNonNullRow || valueLeft == null) {
            return null;
        }
        return false;
    }

    public static CodegenExpression codegen(ExprRelationalOpAllAnyNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprForge[] forges = ExprNodeUtilityQuery.getForges(forge.getForgeRenderable().getChildNodes());
        EPTypeClass valueLeftType = (EPTypeClass)forges[0].getEvaluationType();
        boolean isAll = forge.getForgeRenderable().isAll();
        if (forges.length == 1) {
            return CodegenExpressionBuilder.constant(isAll);
        }
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), ExprRelationalOpAllAnyNodeForgeEval.class, (CodegenScope)codegenClassScope);
        if (isAll) {
            for (int i = 1; i < forges.length; ++i) {
                EPType refType = forges[i].getEvaluationType();
                if (refType != null && refType != EPTypeNull.INSTANCE) continue;
                methodNode.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
                return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
            }
        }
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), "hasNonNullRow", CodegenExpressionBuilder.constantFalse());
        block.declareVar(valueLeftType, "valueLeft", forges[0].evaluateCodegen(valueLeftType, methodNode, exprSymbol, codegenClassScope));
        for (int i = 1; i < forges.length; ++i) {
            CodegenBlock ifLeftNotNull;
            CodegenBlock ifNotNumberElse;
            CodegenBlock ifNotNumber;
            CodegenBlock forEach;
            CodegenBlock blockIfNotNull;
            ExprForge refforge = forges[i];
            String refName = "r" + i;
            EPType refType = refforge.getEvaluationType();
            if ((refType == null || refType == EPTypeNull.INSTANCE) && !isAll) continue;
            EPTypeClass refClass = (EPTypeClass)refType;
            block.declareVar(refClass, refName, refforge.evaluateCodegen(refClass, methodNode, exprSymbol, codegenClassScope));
            if (JavaClassHelper.isImplementsInterface(refClass, Collection.class)) {
                blockIfNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refName)));
                forEach = blockIfNotNull.forEach(EPTypePremade.OBJECT.getEPType(), "item", CodegenExpressionBuilder.ref(refName));
                ifNotNumber = forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("item"), EPTypePremade.NUMBER.getEPType())));
                if (isAll) {
                    ifNotNumber.ifRefNullReturnNull("item");
                }
                ifNotNumberElse = ifNotNumber.ifElse();
                ifNotNumberElse.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                ifLeftNotNull = ifNotNumberElse.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
                ifLeftNotNull.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("item")), EPTypePremade.NUMBER.getEPType()))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(refClass, Map.class)) {
                blockIfNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refName)));
                forEach = blockIfNotNull.forEach(EPTypePremade.OBJECT.getEPType(), "item", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(refName), "keySet", new CodegenExpression[0]));
                ifNotNumber = forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("item"), EPTypePremade.NUMBER.getEPType())));
                if (isAll) {
                    ifNotNumber.ifRefNullReturnNull("item");
                }
                ifNotNumberElse = ifNotNumber.ifElse();
                ifNotNumberElse.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                ifLeftNotNull = ifNotNumberElse.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
                ifLeftNotNull.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("item")), EPTypePremade.NUMBER.getEPType()))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (refClass.getType().isArray()) {
                blockIfNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refName)));
                EPTypeClass componentType = JavaClassHelper.getArrayComponentType(refClass);
                CodegenBlock forLoopArray = blockIfNotNull.forLoopIntSimple("index", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref(refName)));
                forLoopArray.declareVar(JavaClassHelper.getBoxedType(componentType), "item", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref(refName), CodegenExpressionBuilder.ref("index")));
                CodegenBlock ifItemNull = forLoopArray.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("item")));
                if (isAll) {
                    ifItemNull.ifReturn(CodegenExpressionBuilder.constantNull());
                }
                CodegenBlock ifItemNotNull = ifItemNull.ifElse();
                ifItemNotNull.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                CodegenBlock ifLeftNotNull2 = ifItemNotNull.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
                ifLeftNotNull2.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.ref("item"), EPTypePremade.NUMBER.getEPType()))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (!JavaClassHelper.isSubclassOrImplementsInterface((EPType)JavaClassHelper.getBoxedType(refClass), Number.class)) {
                if (!refClass.getType().isPrimitive()) {
                    block.ifRefNullReturnNull(refName);
                }
                block.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                if (!isAll) continue;
                block.blockReturn(CodegenExpressionBuilder.constantNull());
                continue;
            }
            if (refClass.getType().isPrimitive()) {
                block.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                block.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.ref(refName), refClass))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (isAll) {
                block.ifRefNullReturnNull(refName);
            }
            CodegenBlock ifRefNotNull = block.ifRefNotNull(refName);
            ifRefNotNull.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
            CodegenBlock ifLeftNotNull3 = ifRefNotNull.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
            ifLeftNotNull3.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.ref(refName), EPTypePremade.NUMBER.getEPType()))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
        }
        block.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref("hasNonNullRow"))).blockReturn(CodegenExpressionBuilder.constantNull());
        if (!valueLeftType.getType().isPrimitive()) {
            block.ifRefNullReturnNull("valueLeft");
        }
        block.methodReturn(CodegenExpressionBuilder.constant(isAll));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

