/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.time.abacus;

import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Calendar;
import java.util.Date;

public class TimeAbacusMicroseconds
implements TimeAbacus {
    public static final TimeAbacusMicroseconds INSTANCE = new TimeAbacusMicroseconds();
    private static final long serialVersionUID = -1581886702966700798L;

    private TimeAbacusMicroseconds() {
    }

    @Override
    public long deltaForSecondsDouble(double seconds) {
        return Math.round(1000000.0 * seconds);
    }

    @Override
    public CodegenExpression deltaForSecondsDoubleCodegen(CodegenExpressionRef sec, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(Math.class, "round", CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(1000000.0), "*", sec));
    }

    @Override
    public long deltaForSecondsNumber(Number timeInSeconds) {
        if (JavaClassHelper.isFloatingPointNumber(timeInSeconds)) {
            return this.deltaForSecondsDouble(timeInSeconds.doubleValue());
        }
        return 1000000L * timeInSeconds.longValue();
    }

    @Override
    public long calendarSet(long fromTime, Calendar cal) {
        long millis = fromTime / 1000L;
        cal.setTimeInMillis(millis);
        return fromTime - millis * 1000L;
    }

    @Override
    public CodegenExpression calendarSetCodegen(CodegenExpression startLong, CodegenExpression cal, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.LONGBOXED.getEPType(), TimeAbacusMicroseconds.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "fromTime").addParam(EPTypePremade.CALENDAR.getEPType(), "cal").getBlock().declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "millis", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("fromTime"), "/", CodegenExpressionBuilder.constant(1000))).expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.ref("millis"))).methodReturn(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("fromTime"), "-", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("millis"), "*", CodegenExpressionBuilder.constant(1000))));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(startLong).pass(cal).call();
    }

    @Override
    public long calendarGet(Calendar cal, long remainder) {
        return cal.getTimeInMillis() * 1000L + remainder;
    }

    @Override
    public CodegenExpression calendarGetCodegen(CodegenExpression cal, CodegenExpression startRemainder, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.exprDotMethod(cal, "getTimeInMillis", new CodegenExpression[0]), "*", CodegenExpressionBuilder.constant(1000)), "+", startRemainder);
    }

    @Override
    public long getOneSecond() {
        return 1000000L;
    }

    @Override
    public Date toDate(long ts) {
        return new Date(ts / 1000L);
    }

    @Override
    public CodegenExpression toDateCodegen(CodegenExpression ts) {
        return CodegenExpressionBuilder.newInstance(EPTypePremade.DATE.getEPType(), CodegenExpressionBuilder.op(ts, "/", CodegenExpressionBuilder.constant(1000)));
    }
}

