/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.time.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdder;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodDeltaResult;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.TimeProvider;
import java.util.Calendar;
import java.util.TimeZone;

public class TimePeriodComputeConstGivenCalAddEval
implements TimePeriodCompute,
TimePeriodProvide {
    public static final EPTypeClass EPTYPE = new EPTypeClass(TimePeriodComputeConstGivenCalAddEval.class);
    private TimePeriodAdder[] adders;
    private int[] added;
    private TimeAbacus timeAbacus;
    private int indexMicroseconds;
    private TimeZone timeZone;

    public TimePeriodComputeConstGivenCalAddEval() {
    }

    public TimePeriodComputeConstGivenCalAddEval(TimePeriodAdder[] adders, int[] added, TimeAbacus timeAbacus, int indexMicroseconds, TimeZone timeZone) {
        this.adders = adders;
        this.added = added;
        this.timeAbacus = timeAbacus;
        this.indexMicroseconds = indexMicroseconds;
        this.timeZone = timeZone;
    }

    public void setAdders(TimePeriodAdder[] adders) {
        this.adders = adders;
    }

    public void setAdded(int[] added) {
        this.added = added;
    }

    public void setTimeAbacus(TimeAbacus timeAbacus) {
        this.timeAbacus = timeAbacus;
    }

    public void setIndexMicroseconds(int indexMicroseconds) {
        this.indexMicroseconds = indexMicroseconds;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public long deltaAdd(long fromTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long target = this.addSubtract(fromTime, 1);
        return target - fromTime;
    }

    @Override
    public long deltaSubtract(long fromTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long target = this.addSubtract(fromTime, -1);
        return fromTime - target;
    }

    @Override
    public long deltaUseRuntimeTime(EventBean[] eventsPerStream, ExprEvaluatorContext context, TimeProvider timeProvider) {
        return this.deltaAdd(timeProvider.getTime(), eventsPerStream, true, context);
    }

    @Override
    public TimePeriodDeltaResult deltaAddWReference(long fromTime, long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long last;
        while (reference > fromTime) {
            reference -= this.deltaSubtract(reference, eventsPerStream, isNewData, context);
        }
        long next = reference;
        while ((next += this.deltaAdd(last = next, eventsPerStream, isNewData, context)) <= fromTime) {
        }
        return new TimePeriodDeltaResult(next - fromTime, last);
    }

    @Override
    public TimePeriodProvide getNonVariableProvide(ExprEvaluatorContext context) {
        return this;
    }

    private long addSubtract(long fromTime, int factor) {
        Calendar cal = Calendar.getInstance(this.timeZone);
        long remainder = this.timeAbacus.calendarSet(fromTime, cal);
        for (int i = 0; i < this.adders.length; ++i) {
            this.adders[i].add(cal, factor * this.added[i]);
        }
        long result = this.timeAbacus.calendarGet(cal, remainder);
        if (this.indexMicroseconds != -1) {
            result += (long)(factor * this.added[this.indexMicroseconds]);
        }
        return result;
    }
}

