/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.visitor;

import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamExprDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamPropDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamRefNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExprNodeIdentifierAndStreamRefVisitor
implements ExprNodeVisitor {
    private final boolean isVisitAggregateNodes;
    private final boolean isVisitDeclaredExprParams;
    private final boolean isVisitDeclaredExprBody;
    private List<ExprNodePropOrStreamDesc> refs;
    private boolean hasWildcardOrStreamAlias;

    public ExprNodeIdentifierAndStreamRefVisitor(boolean isVisitAggregateNodes) {
        this(isVisitAggregateNodes, false, true);
    }

    public ExprNodeIdentifierAndStreamRefVisitor(boolean isVisitAggregateNodes, boolean isVisitDeclaredExprParams, boolean isVisitDeclaredExprBody) {
        this.isVisitAggregateNodes = isVisitAggregateNodes;
        this.isVisitDeclaredExprParams = isVisitDeclaredExprParams;
        this.isVisitDeclaredExprBody = isVisitDeclaredExprBody;
    }

    @Override
    public boolean isVisit(ExprNode exprNode) {
        if (exprNode instanceof ExprLambdaGoesNode) {
            return false;
        }
        if (!this.isVisitDeclaredExprBody && exprNode instanceof ExprDeclaredNode) {
            return false;
        }
        if (this.isVisitAggregateNodes) {
            return true;
        }
        return !(exprNode instanceof ExprAggregateNode);
    }

    public List<ExprNodePropOrStreamDesc> getRefs() {
        if (this.refs == null) {
            return Collections.emptyList();
        }
        return this.refs;
    }

    @Override
    public void visit(ExprNode exprNode) {
        if (exprNode instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)exprNode;
            int streamId = identNode.getStreamId();
            String propertyName = identNode.getResolvedPropertyName();
            this.checkAllocatedRefs();
            this.refs.add(new ExprNodePropOrStreamPropDesc(streamId, propertyName));
        } else if (exprNode instanceof ExprStreamRefNode) {
            ExprStreamRefNode streamRefNode = (ExprStreamRefNode)exprNode;
            Integer stream = streamRefNode.getStreamReferencedIfAny();
            this.checkAllocatedRefs();
            if (stream != null) {
                this.refs.add(new ExprNodePropOrStreamExprDesc(stream, streamRefNode));
            }
            if (exprNode instanceof ExprWildcard || exprNode instanceof ExprStreamUnderlyingNode) {
                this.hasWildcardOrStreamAlias = true;
            }
        }
    }

    public void reset() {
        if (this.refs != null) {
            this.refs.clear();
        }
    }

    @Override
    public boolean isWalkDeclExprParam() {
        return this.isVisitDeclaredExprParams;
    }

    public boolean isHasWildcardOrStreamAlias() {
        return this.hasWildcardOrStreamAlias;
    }

    private void checkAllocatedRefs() {
        if (this.refs == null) {
            this.refs = new ArrayList<ExprNodePropOrStreamDesc>(4);
        }
    }
}

