/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.visitor;

import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExprNodeVariableVisitor
implements ExprNodeVisitor {
    private final VariableCompileTimeResolver variableCompileTimeResolver;
    private Map<String, VariableMetaData> variableNames;

    public ExprNodeVariableVisitor(VariableCompileTimeResolver variableCompileTimeResolver) {
        this.variableCompileTimeResolver = variableCompileTimeResolver;
    }

    @Override
    public boolean isVisit(ExprNode exprNode) {
        return true;
    }

    public boolean isHasVariables() {
        return this.variableNames != null && !this.variableNames.isEmpty();
    }

    @Override
    public void visit(ExprNode exprNode) {
        ExprDotNode exprDotNode;
        VariableMetaData metadata;
        if (exprNode instanceof ExprDotNode && (metadata = (exprDotNode = (ExprDotNode)exprNode).isVariableOpGetName(this.variableCompileTimeResolver)) != null) {
            this.addVariableName(metadata);
        }
        if (exprNode instanceof ExprVariableNode) {
            ExprVariableNode variableNode = (ExprVariableNode)((Object)exprNode);
            metadata = variableNode.getVariableMetadata();
            this.addVariableName(metadata);
        }
    }

    public Map<String, VariableMetaData> getVariableNames() {
        return this.variableNames;
    }

    private void addVariableName(VariableMetaData meta) {
        if (this.variableNames == null) {
            this.variableNames = new LinkedHashMap<String, VariableMetaData>();
        }
        this.variableNames.put(meta.getVariableName(), meta);
    }
}

