/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.processor;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstance;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDDelete;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDInsertInto;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDUpdate;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.lang.annotation.Annotation;
import java.util.Collection;

public class FireAndForgetInstanceNamedWindow
extends FireAndForgetInstance {
    private final NamedWindowInstance processorInstance;

    public FireAndForgetInstanceNamedWindow(NamedWindowInstance processorInstance) {
        this.processorInstance = processorInstance;
    }

    public NamedWindowInstance getProcessorInstance() {
        return this.processorInstance;
    }

    @Override
    public AgentInstanceContext getAgentInstanceContext() {
        return this.processorInstance.getTailViewInstance().getAgentInstanceContext();
    }

    @Override
    public Collection<EventBean> snapshotBestEffort(QueryGraph queryGraph, Annotation[] annotations) {
        return this.processorInstance.getTailViewInstance().snapshot(queryGraph, annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBean[] processInsert(FAFQueryMethodIUDInsertInto insert) {
        EventBean[] inserted;
        AgentInstanceContext ctx = this.processorInstance.getTailViewInstance().getAgentInstanceContext();
        if (insert.getInsertHelpers().length == 1) {
            EventBean event = insert.getInsertHelpers()[0].process(CollectionUtil.EVENTBEANARRAY_EMPTY, true, true, ctx);
            inserted = new EventBean[]{event};
        } else {
            inserted = new EventBean[insert.getInsertHelpers().length];
            for (int i = 0; i < insert.getInsertHelpers().length; ++i) {
                EventBean event;
                inserted[i] = event = insert.getInsertHelpers()[i].process(CollectionUtil.EVENTBEANARRAY_EMPTY, true, true, ctx);
            }
        }
        try {
            StatementAgentInstanceLock ailock = ctx.getAgentInstanceLock();
            ailock.acquireWriteLock();
            try {
                this.processorInstance.getRootViewInstance().update(inserted, null);
            }
            catch (EPException ex) {
                this.processorInstance.getRootViewInstance().update(null, inserted);
                throw ex;
            }
            finally {
                ailock.releaseWriteLock();
            }
            EventBean[] eventBeanArray = inserted;
            return eventBeanArray;
        }
        finally {
            ctx.getTableExprEvaluatorContext().releaseAcquiredLocks();
        }
    }

    @Override
    public EventBean[] processDelete(FAFQueryMethodIUDDelete delete) {
        return this.processorInstance.getTailViewInstance().snapshotDelete(delete.getQueryGraph(), delete.getOptionalWhereClause(), delete.getAnnotations());
    }

    @Override
    public EventBean[] processUpdate(FAFQueryMethodIUDUpdate update) {
        return this.processorInstance.getTailViewInstance().snapshotUpdate(update.getQueryGraph(), update.getOptionalWhereClause(), update.getUpdateHelperNamedWindow(), update.getAnnotations());
    }

    @Override
    public Viewable getTailViewInstance() {
        return this.processorInstance.getTailViewInstance();
    }
}

