/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.processor;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstance;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetQueryExec;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDDelete;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDInsertInto;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDUpdate;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.table.core.TableEvalLockUtil;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class FireAndForgetInstanceTable
extends FireAndForgetInstance {
    private final TableInstance instance;

    public FireAndForgetInstanceTable(TableInstance instance) {
        this.instance = instance;
    }

    @Override
    public EventBean[] processInsert(FAFQueryMethodIUDInsertInto insert) {
        TableEvalLockUtil.obtainLockUnless(this.instance.getTableLevelRWLock().writeLock(), this.instance.getAgentInstanceContext().getTableExprEvaluatorContext());
        EventBean[] inserted = new EventBean[insert.getInsertHelpers().length];
        for (int i = 0; i < insert.getInsertHelpers().length; ++i) {
            inserted[i] = insert.getInsertHelpers()[i].process(new EventBean[0], true, true, this.instance.getAgentInstanceContext());
        }
        try {
            for (EventBean event : inserted) {
                AggregationRow aggs = this.instance.getTable().getAggregationRowFactory().make();
                ((Object[])event.getUnderlying())[0] = aggs;
                this.instance.addEvent(event);
            }
        }
        catch (EPException ex) {
            for (EventBean event : inserted) {
                this.instance.deleteEvent(event);
            }
            throw ex;
        }
        return CollectionUtil.EVENTBEANARRAY_EMPTY;
    }

    @Override
    public EventBean[] processDelete(FAFQueryMethodIUDDelete delete) {
        TableEvalLockUtil.obtainLockUnless(this.instance.getTableLevelRWLock().writeLock(), this.instance.getAgentInstanceContext().getTableExprEvaluatorContext());
        if (delete.getOptionalWhereClause() == null) {
            this.instance.clearInstance();
            return CollectionUtil.EVENTBEANARRAY_EMPTY;
        }
        Collection<EventBean> found = this.snapshotAndApplyFilter(delete.getQueryGraph(), delete.getAnnotations(), delete.getOptionalWhereClause(), this.instance.getAgentInstanceContext());
        for (EventBean event : found) {
            this.instance.deleteEvent(event);
        }
        return CollectionUtil.EVENTBEANARRAY_EMPTY;
    }

    @Override
    public EventBean[] processUpdate(FAFQueryMethodIUDUpdate update) {
        TableEvalLockUtil.obtainLockUnless(this.instance.getTableLevelRWLock().writeLock(), this.instance.getAgentInstanceContext().getTableExprEvaluatorContext());
        Collection<EventBean> events = this.snapshotAndApplyFilter(update.getQueryGraph(), update.getAnnotations(), update.getOptionalWhereClause(), this.instance.getAgentInstanceContext());
        if (events != null && events.isEmpty()) {
            return CollectionUtil.EVENTBEANARRAY_EMPTY;
        }
        EventBean[] eventsPerStream = new EventBean[3];
        if (events == null) {
            update.getTableUpdateStrategy().updateTable(this.instance.getEventCollection(), this.instance, eventsPerStream, this.instance.getAgentInstanceContext());
        } else {
            update.getTableUpdateStrategy().updateTable(events, this.instance, eventsPerStream, this.instance.getAgentInstanceContext());
        }
        return CollectionUtil.EVENTBEANARRAY_EMPTY;
    }

    @Override
    public Collection<EventBean> snapshotBestEffort(QueryGraph queryGraph, Annotation[] annotations) {
        TableEvalLockUtil.obtainLockUnless(this.instance.getTableLevelRWLock().readLock(), this.instance.getAgentInstanceContext());
        Collection<EventBean> events = this.snapshotNullWhenNoIndex(queryGraph, annotations, null, null);
        if (events != null) {
            return events;
        }
        return this.instance.getEventCollection();
    }

    @Override
    public AgentInstanceContext getAgentInstanceContext() {
        return this.instance.getAgentInstanceContext();
    }

    @Override
    public Viewable getTailViewInstance() {
        return null;
    }

    private Collection<EventBean> snapshotNullWhenNoIndex(QueryGraph queryGraph, Annotation[] annotations, ExprNode optionalWhereClause, AgentInstanceContext agentInstanceContext) {
        return FireAndForgetQueryExec.snapshot(queryGraph, annotations, null, this.instance.getIndexRepository(), this.instance.getTable().getName(), this.instance.getAgentInstanceContext());
    }

    private Collection<EventBean> snapshotAndApplyFilter(QueryGraph queryGraph, Annotation[] annotations, ExprEvaluator filterExpr, AgentInstanceContext agentInstanceContext) {
        Collection<EventBean> indexedResult = this.snapshotNullWhenNoIndex(queryGraph, annotations, null, null);
        if (indexedResult != null) {
            if (indexedResult.isEmpty() || filterExpr == null) {
                return indexedResult;
            }
            ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(Math.min(indexedResult.size(), 16));
            ExprNodeUtilityEvaluate.applyFilterExpressionIterable(indexedResult.iterator(), filterExpr, agentInstanceContext, deque);
            return deque;
        }
        Collection<EventBean> sourceCollection = this.instance.getEventCollection();
        Iterator<EventBean> it = sourceCollection.iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(sourceCollection.size());
        if (filterExpr != null) {
            ExprNodeUtilityEvaluate.applyFilterExpressionIterable(sourceCollection.iterator(), filterExpr, agentInstanceContext, deque);
        } else {
            while (it.hasNext()) {
                deque.add(it.next());
            }
        }
        return deque;
    }
}

