/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecBase;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecOptions;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.ViewSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDBaseForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDInsertInto;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeHelperForge;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessor;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorFactory;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorForge;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorUtil;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectProcessorArgs;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.util.UuidGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FAFQueryMethodIUDInsertIntoForge
extends FAFQueryMethodIUDBaseForge {
    private static final int MAX_MULTIROW = 1000;
    private SelectExprProcessorForge[] insertHelpers;

    public FAFQueryMethodIUDInsertIntoForge(StatementSpecCompiled specCompiled, Compilable compilable, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        super(FAFQueryMethodIUDInsertIntoForge.associatedFromClause(specCompiled, services), compilable, statementRawInfo, services);
    }

    @Override
    protected void initExec(String aliasName, StatementSpecCompiled spec, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        FireAndForgetSpecInsert insert;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(true);
        ExprValidationContext validationContext = new ExprValidationContextBuilder(streamTypeService, statementRawInfo, services).withAllowBindingConsumption(true).build();
        String[] assignedSequentialNames = null;
        if (spec.getRaw().getInsertIntoDesc().getColumnNames().isEmpty() && (insert = (FireAndForgetSpecInsert)spec.getRaw().getFireAndForgetSpec()).isUseValuesKeyword()) {
            assignedSequentialNames = this.processor.getEventTypePublic().getPropertyNames();
        }
        if (spec.getRaw().getInsertIntoDesc().getEventPrecedence() != null) {
            throw new ExprValidationException("Fire-and-forget insert-queries do not allow event-precedence");
        }
        FireAndForgetSpecInsert insertSpec = (FireAndForgetSpecInsert)spec.getRaw().getFireAndForgetSpec();
        if (insertSpec.getMultirow().isEmpty()) {
            List<SelectClauseElementCompiled> selectNoWildcard = InfraOnMergeHelperForge.compileSelectNoWildcard(UuidGenerator.generate(), Arrays.asList(spec.getSelectClauseCompiled().getSelectExprList()));
            SelectExprProcessorForge insert2 = this.initExecRow(selectNoWildcard, spec, assignedSequentialNames, validationContext, streamTypeService, statementRawInfo, services);
            this.insertHelpers = new SelectExprProcessorForge[]{insert2};
        } else {
            int numRows = insertSpec.getMultirow().size();
            if (numRows > 1000) {
                throw new ExprValidationException("Insert-into number-of-rows exceeds the maximum of 1000 rows as the query provides " + numRows + " rows");
            }
            int count = 0;
            this.insertHelpers = new SelectExprProcessorForge[insertSpec.getMultirow().size()];
            for (List<ExprNode> row : insertSpec.getMultirow()) {
                ArrayList<SelectClauseElementCompiled> selected = new ArrayList<SelectClauseElementCompiled>(row.size());
                for (ExprNode expr : row) {
                    selected.add(new SelectClauseExprCompiledSpec(expr, null, null, false));
                }
                try {
                    this.insertHelpers[count++] = this.initExecRow(selected, spec, assignedSequentialNames, validationContext, streamTypeService, statementRawInfo, services);
                }
                catch (ExprValidationException ex) {
                    if (insertSpec.getMultirow().size() == 1) {
                        throw ex;
                    }
                    throw new ExprValidationException("Failed to validate multi-row insert at row " + count + " of " + this.insertHelpers.length + ": " + ex.getMessage(), ex);
                }
            }
        }
    }

    private SelectExprProcessorForge initExecRow(List<SelectClauseElementCompiled> select, StatementSpecCompiled spec, String[] assignedSequentialNames, ExprValidationContext validationContext, StreamTypeService streamTypeService, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        int count = -1;
        for (SelectClauseElementCompiled compiled : select) {
            ++count;
            if (!(compiled instanceof SelectClauseExprCompiledSpec)) continue;
            SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)compiled;
            ExprNode validatedExpression = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.SELECT, expr.getSelectExpression(), validationContext);
            expr.setSelectExpression(validatedExpression);
            if (expr.getAssignedName() != null) continue;
            if (expr.getProvidedName() == null) {
                if (assignedSequentialNames != null && count < assignedSequentialNames.length) {
                    expr.setAssignedName(assignedSequentialNames[count]);
                    continue;
                }
                expr.setAssignedName(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(expr.getSelectExpression()));
                continue;
            }
            expr.setAssignedName(expr.getProvidedName());
        }
        SelectClauseElementCompiled[] selected = select.toArray(new SelectClauseElementCompiled[0]);
        EventType optionalInsertIntoEventType = this.processor.getEventTypeRSPInputEvents();
        SelectProcessorArgs args = new SelectProcessorArgs(selected, null, false, optionalInsertIntoEventType, null, streamTypeService, true, spec.getAnnotations(), statementRawInfo, services);
        return SelectExprProcessorFactory.getProcessor(args, spec.getRaw().getInsertIntoDesc(), false).getForge();
    }

    @Override
    protected EPTypeClass typeOfMethod() {
        return FAFQueryMethodIUDInsertInto.EPTYPE;
    }

    @Override
    protected void makeInlineSpecificSetter(CodegenExpressionRef queryMethod, CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().declareVar(SelectExprProcessor.EPTYPEARRAY, "helpers", CodegenExpressionBuilder.newArrayByLength(SelectExprProcessor.EPTYPE, CodegenExpressionBuilder.constant(this.insertHelpers.length)));
        for (int i = 0; i < this.insertHelpers.length; ++i) {
            CodegenExpressionNewAnonymousClass select = SelectExprProcessorUtil.makeAnonymous(this.insertHelpers[i], method, symbols.getAddInitSvc(method), classScope);
            method.getBlock().assignArrayElement("helpers", CodegenExpressionBuilder.constant(i), (CodegenExpression)select);
        }
        method.getBlock().exprDotMethod(queryMethod, "setInsertHelpers", CodegenExpressionBuilder.ref("helpers"));
    }

    private static StatementSpecCompiled associatedFromClause(StatementSpecCompiled statementSpec, StatementCompileTimeServices services) throws ExprValidationException {
        StatementSpecRaw raw = statementSpec.getRaw();
        if (raw.getWhereClause() != null || statementSpec.getStreamSpecs().length > 0 || raw.getHavingClause() != null || raw.getOutputLimitSpec() != null || raw.getForClauseSpec() != null || raw.getMatchRecognizeSpec() != null || raw.getOrderByList() != null && !raw.getOrderByList().isEmpty() || raw.getRowLimitSpec() != null) {
            throw new ExprValidationException("Insert-into fire-and-forget query can only consist of an insert-into clause and a select-clause");
        }
        String infraName = statementSpec.getRaw().getInsertIntoDesc().getEventTypeName();
        NamedWindowMetaData namedWindow = services.getNamedWindowCompileTimeResolver().resolve(infraName);
        TableMetaData table = services.getTableCompileTimeResolver().resolve(infraName);
        if (namedWindow == null && table == null) {
            throw new ExprValidationException("Failed to find named window or table '" + infraName + "'");
        }
        StreamSpecBase stream = namedWindow != null ? new NamedWindowConsumerStreamSpec(namedWindow, null, new ViewSpec[0], Collections.emptyList(), StreamSpecOptions.DEFAULT, null) : new TableQueryStreamSpec(null, new ViewSpec[0], StreamSpecOptions.DEFAULT, table, Collections.emptyList());
        return new StatementSpecCompiled(statementSpec, new StreamSpecCompiled[]{stream});
    }
}

