/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.mgr.ContextDeployTimeResolver;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.context.mgr.ContextManager;
import com.espertech.esper.common.internal.context.util.StatementContextRuntimeServices;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.EPPreparedQueryResult;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelect;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExec;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecUtil;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectNoFromExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayDeque;
import java.util.Collection;

public class FAFQueryMethodSelectExecGivenContextNoFromClause
implements FAFQueryMethodSelectExec {
    private final StatementContextRuntimeServices svc;
    private FAFQueryMethodSelectNoFromExprEvaluatorContext exprEvaluatorContext;

    public FAFQueryMethodSelectExecGivenContextNoFromClause(StatementContextRuntimeServices svc) {
        this.svc = svc;
    }

    @Override
    public EPPreparedQueryResult execute(FAFQueryMethodSelect select, ContextPartitionSelector[] contextPartitionSelectors, FAFQueryMethodAssignerSetter assignerSetter, ContextManagementService contextManagementService) {
        if (contextPartitionSelectors != null && contextPartitionSelectors.length > 1) {
            throw new IllegalArgumentException("Fire-and-forget queries without a from-clause allow only a single context partition selector");
        }
        String contextDeploymentId = ContextDeployTimeResolver.resolveContextDeploymentId(select.getContextModuleName(), NameAccessModifier.PUBLIC, select.getContextName(), null, this.svc.getContextPathRegistry());
        ContextManager contextManager = contextManagementService.getContextManager(contextDeploymentId, select.getContextName());
        if (contextManager == null) {
            throw new EPException("Failed to find context manager for context '" + select.getContextName() + "'");
        }
        ContextPartitionSelectorAll singleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : ContextPartitionSelectorAll.INSTANCE;
        Collection<Integer> agentInstanceIds = contextManager.getRealization().getAgentInstanceIds(singleSelector);
        this.exprEvaluatorContext = new FAFQueryMethodSelectNoFromExprEvaluatorContext(this.svc, select);
        ResultSetProcessor resultSetProcessor = FAFQueryMethodSelectExecUtil.processorWithAssign(select.getResultSetProcessorFactoryProvider(), this.exprEvaluatorContext, null, assignerSetter, select.getTableAccesses(), select.getSubselects());
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>();
        EventBean[] input = new EventBean[]{null};
        for (Integer agentInstanceId : agentInstanceIds) {
            UniformPair<EventBean[]> results;
            Object result;
            this.exprEvaluatorContext.setContextProperties(contextManager.getContextPropertiesEvent(agentInstanceId));
            if (select.getWhereClause() != null && ((result = select.getWhereClause().evaluate(CollectionUtil.EVENTBEANARRAY_EMPTY, true, this.exprEvaluatorContext)) == null || !((Boolean)result).booleanValue()) || (results = resultSetProcessor.processViewResult(input, null, true)).getFirst() == null || results.getFirst().length <= 0) continue;
            events.add(results.getFirst()[0]);
        }
        EventBean[] result = events.toArray(new EventBean[0]);
        EventBean[] distinct = EventBeanUtility.getDistinctByProp(result, select.getDistinctKeyGetter());
        return new EPPreparedQueryResult(resultSetProcessor.getResultEventType(), distinct);
    }

    @Override
    public void releaseTableLocks(FireAndForgetProcessor[] processors) {
        if (this.exprEvaluatorContext != null) {
            this.exprEvaluatorContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
        }
        this.exprEvaluatorContext = null;
    }
}

