/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstance;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.EPPreparedQueryResult;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelect;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExec;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecUtil;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodUtil;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;

public class FAFQueryMethodSelectExecGivenContextNoJoin
implements FAFQueryMethodSelectExec {
    public static final FAFQueryMethodSelectExec INSTANCE = new FAFQueryMethodSelectExecGivenContextNoJoin();

    private FAFQueryMethodSelectExecGivenContextNoJoin() {
    }

    @Override
    public EPPreparedQueryResult execute(FAFQueryMethodSelect select, ContextPartitionSelector[] contextPartitionSelectors, FAFQueryMethodAssignerSetter assignerSetter, ContextManagementService contextManagementService) {
        FireAndForgetProcessor processor = select.getProcessors()[0];
        ContextPartitionSelector singleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : null;
        Collection<Integer> agentInstanceIds = FAFQueryMethodUtil.agentInstanceIds(processor, singleSelector, contextManagementService);
        ArrayList<ContextPartitionResult> contextPartitionResults = new ArrayList<ContextPartitionResult>();
        for (int agentInstanceId : agentInstanceIds) {
            FireAndForgetInstance processorInstance = processor.getProcessorInstanceContextById(agentInstanceId);
            if (processorInstance == null) continue;
            Collection<EventBean> coll = processorInstance.snapshotBestEffort(select.getQueryGraph(), select.getAnnotations());
            contextPartitionResults.add(new ContextPartitionResult(coll, processorInstance.getAgentInstanceContext()));
        }
        ArrayDeque<EventBean[]> events = new ArrayDeque<EventBean[]>();
        ResultSetProcessor resultSetProcessor = null;
        for (ContextPartitionResult contextPartitionResult : contextPartitionResults) {
            resultSetProcessor = FAFQueryMethodSelectExecUtil.processorWithAssign(select.getResultSetProcessorFactoryProvider(), contextPartitionResult.getContext(), assignerSetter, select.getTableAccesses(), select.getSubselects());
            Collection<EventBean> snapshot = contextPartitionResult.getEvents();
            if (select.getWhereClause() != null) {
                snapshot = FAFQueryMethodSelectExecUtil.filtered(snapshot, select.getWhereClause(), contextPartitionResult.context);
            }
            EventBean[] rows = snapshot.toArray(new EventBean[snapshot.size()]);
            resultSetProcessor.setExprEvaluatorContext(contextPartitionResult.getContext());
            UniformPair<EventBean[]> results = resultSetProcessor.processViewResult(rows, null, true);
            if (results == null || results.getFirst() == null || results.getFirst().length <= 0) continue;
            events.add(results.getFirst());
        }
        EventBean[] distinct = EventBeanUtility.getDistinctByProp(EventBeanUtility.flatten(events), select.getDistinctKeyGetter());
        return new EPPreparedQueryResult(select.getEventType(), distinct);
    }

    @Override
    public void releaseTableLocks(FireAndForgetProcessor[] processors) {
        FAFQueryMethodSelectExecUtil.releaseTableLocks(processors);
    }

    private static class ContextPartitionResult {
        private final Collection<EventBean> events;
        private final AgentInstanceContext context;

        private ContextPartitionResult(Collection<EventBean> events, AgentInstanceContext context) {
            this.events = events;
            this.context = context;
        }

        public Collection<EventBean> getEvents() {
            return this.events;
        }

        public AgentInstanceContext getContext() {
            return this.context;
        }
    }
}

